/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.util.structures;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.diffmerge.util.structures.IEqualityBasedStructure;
import org.eclipse.emf.diffmerge.util.structures.IEqualityTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FArrayList<E>
extends BasicEList<E>
implements IEqualityBasedStructure {
    private static final long serialVersionUID = -8125124237694239450L;
    private IEqualityTester _equalityTester;

    public FArrayList() {
        this(null);
    }

    public FArrayList(IEqualityTester tester_p) {
        this.setEqualityTester(tester_p);
    }

    public FArrayList(int initialCapacity_p, IEqualityTester tester_p) {
        super(initialCapacity_p);
        this.setEqualityTester(tester_p);
    }

    public FArrayList(Collection<? extends E> collection_p, IEqualityTester tester_p) {
        super(collection_p);
        this.setEqualityTester(tester_p);
    }

    public boolean contains(Object object_p) {
        return this.indexOf(object_p) >= 0;
    }

    protected boolean equalObjects(Object firstObject_p, Object secondObject_p) {
        return this._equalityTester.areEqual(firstObject_p, secondObject_p);
    }

    protected Collection<E> getDuplicates(Collection<?> collection_p) {
        Object result;
        if (collection_p.isEmpty()) {
            result = ECollections.emptyEList();
        } else {
            result = new FArrayList<E>(collection_p.size(), this.getEqualityTester());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!collection_p.contains(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    @Override
    public IEqualityTester getEqualityTester() {
        return this._equalityTester;
    }

    protected Collection<E> getNonDuplicates(Collection<? extends E> collection_p) {
        FArrayList<E> result = new FArrayList<E>(collection_p.size(), this.getEqualityTester());
        for (E object : collection_p) {
            if (this.contains(object)) continue;
            result.add(object);
        }
        return result;
    }

    public int indexOf(Object object_p) {
        int i = 0;
        while (i < this.size) {
            if (this.equalObjects(object_p, this.data[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object object_p) {
        int i = this.size - 1;
        while (i >= 0) {
            if (this.equalObjects(object_p, this.data[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private void setEqualityTester(IEqualityTester tester_p) {
        this._equalityTester = tester_p != null ? tester_p : DEFAULT_TESTER;
    }

    protected final boolean useEquals() {
        return false;
    }
}

