/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public abstract class EditComboBoxCellEditor
extends CellEditor {
    protected Composite fEditor;
    protected CCombo combo;
    protected String fSelection;
    protected LabelValuePair[] fItems;
    protected Object fValue;
    protected boolean fAddItems;
    private boolean needQuotes = false;
    private int pairDataType;
    private int keyCount = 0;
    protected LabelValuePair newItem = null;
    Control focusControl = null;
    KeyAdapter keyAdapter = null;
    private ExpressionHelper eh = new ExpressionHelper();

    public void createItems(LabelValuePair[] items) {
        this.fItems = items;
    }

    public LabelValuePair[] getComboBoxItems() {
        return this.fItems;
    }

    public EditComboBoxCellEditor(Composite parent, boolean addItems) {
        super(parent);
        this.fItems = new LabelValuePair[1];
        this.fItems[0] = new LabelValuePair("", "");
        this.fAddItems = addItems;
    }

    public EditComboBoxCellEditor(Composite parent, LabelValuePair[] items, boolean addItems) {
        super(parent);
        this.fItems = items;
        this.combo.setText("");
        this.fAddItems = addItems;
    }

    protected void fireCancelEditor() {
        this.newItem = null;
        super.fireCancelEditor();
    }

    protected void fireApplyEditorValue() {
        super.fireApplyEditorValue();
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        ++this.keyCount;
        super.keyReleaseOccured(keyEvent);
    }

    public void deactivate() {
        super.deactivate();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            this.focusControl.setFocus();
        }
        this.keyCount = 0;
    }

    public void activate() {
        if (this.fAddItems && this.newItem != null) {
            boolean addNeeded = true;
            if (this.fItems != null) {
                int listSize = this.fItems.length;
                int i = 0;
                while (i < listSize) {
                    if (this.newItem.fLabel.equals(this.fItems[i].fLabel)) {
                        addNeeded = false;
                        break;
                    }
                    ++i;
                }
            }
            if (addNeeded) {
                Vector<Object> vectTemp;
                List<LabelValuePair> tmpList = null;
                if (this.fItems != null) {
                    tmpList = Arrays.asList(this.fItems);
                    vectTemp = new Vector<LabelValuePair>(tmpList);
                } else {
                    vectTemp = new Vector<LabelValuePair>();
                }
                vectTemp.addElement(this.newItem);
                LabelValuePair[] newItems = new LabelValuePair[vectTemp.size()];
                int i = 0;
                while (i < vectTemp.size()) {
                    newItems[i] = (LabelValuePair)vectTemp.elementAt(i);
                    ++i;
                }
                this.fItems = newItems;
            }
        }
        this.newItem = null;
        if (Display.getCurrent() != null) {
            this.focusControl = Display.getCurrent().getFocusControl();
        }
        super.activate();
    }

    protected KeyAdapter getKeyAdapter() {
        if (this.keyAdapter == null) {
            return new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                        EditComboBoxCellEditor.this.activate();
                    }
                }

                public void keyReleased(KeyEvent e) {
                    if (EditComboBoxCellEditor.this.getControl() == null || EditComboBoxCellEditor.this.getControl().isDisposed()) {
                        return;
                    }
                    if (e.keyCode == 27) {
                        EditComboBoxCellEditor.this.fireCancelEditor();
                        EditComboBoxCellEditor.this.keyReleaseOccured(e);
                    } else if (e.keyCode != 0x1000002 && e.keyCode != 0x1000001) {
                        int index = EditComboBoxCellEditor.this.combo.getSelectionIndex();
                        if (index >= 0) {
                            String selection = EditComboBoxCellEditor.this.combo.getItem(index);
                            int i = 0;
                            while (i < EditComboBoxCellEditor.this.fItems.length) {
                                if (EditComboBoxCellEditor.this.fItems[i].fLabel.equals(selection)) {
                                    EditComboBoxCellEditor.this.newItem = EditComboBoxCellEditor.this.createComboBoxItem(selection);
                                    EditComboBoxCellEditor.this.doSetValue(EditComboBoxCellEditor.this.fItems[i].fValue);
                                    break;
                                }
                                ++i;
                            }
                        } else {
                            EditComboBoxCellEditor.this.newItem = EditComboBoxCellEditor.this.createComboBoxItem(EditComboBoxCellEditor.this.appendQuotes(EditComboBoxCellEditor.this.combo.getText()));
                            EditComboBoxCellEditor.this.doSetValue(EditComboBoxCellEditor.this.newItem.fValue);
                        }
                        EditComboBoxCellEditor.this.keyReleaseOccured(e);
                    }
                }
            };
        }
        return this.keyAdapter;
    }

    protected Control createControl(Composite parent) {
        this.fEditor = new Composite(parent, 0);
        this.fEditor.setLayout((Layout)new ComboCellLayout());
        this.combo = new CCombo(this.fEditor, 0);
        this.combo.setBackground(parent.getBackground());
        this.combo.setText("");
        this.combo.addKeyListener((KeyListener)this.getKeyAdapter());
        this.combo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                if (EditComboBoxCellEditor.this.combo.getSelectionIndex() >= 0) {
                    EditComboBoxCellEditor.this.fireApplyEditorValue();
                } else {
                    EditComboBoxCellEditor.this.commitValue();
                }
                EditComboBoxCellEditor.this.deactivate();
                EditComboBoxCellEditor.this.combo.removeKeyListener((KeyListener)EditComboBoxCellEditor.this.getKeyAdapter());
            }

            public void widgetSelected(SelectionEvent event) {
                if (EditComboBoxCellEditor.this.combo.getSelectionIndex() >= 0) {
                    String selection = EditComboBoxCellEditor.this.combo.getItem(EditComboBoxCellEditor.this.combo.getSelectionIndex());
                    int i = 0;
                    while (i < EditComboBoxCellEditor.this.fItems.length) {
                        if (EditComboBoxCellEditor.this.fItems[i].fLabel.equals(selection)) {
                            EditComboBoxCellEditor.this.doSetValue(EditComboBoxCellEditor.this.fItems[i].fValue);
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        this.combo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                EditComboBoxCellEditor.this.commitValue();
                EditComboBoxCellEditor.this.forwardFocusLost();
            }

            public void focusGained(FocusEvent e) {
                EditComboBoxCellEditor.this.refreshComboItems();
                EditComboBoxCellEditor.this.fillCombo();
            }
        });
        this.setValueValid(true);
        return this.fEditor;
    }

    protected void commitValue() {
        if (this.keyCount > 0) {
            this.combo.setText(this.appendQuotes(this.combo.getText()));
            LabelValuePair comboItem = this.createComboBoxItem(this.combo.getText());
            this.doSetValue(comboItem.fValue);
            this.keyCount = 0;
        }
        this.fireApplyEditorValue();
    }

    protected void refreshComboItems() {
    }

    protected void fillCombo() {
        if (this.fItems != null) {
            String[] labels = new String[this.fItems.length];
            int i = 0;
            while (i < labels.length) {
                LabelValuePair item = this.fItems[i];
                labels[i] = item.fLabel;
                if (this.fSelection == null && this.fValue != null && this.fValue.equals(item.fValue)) {
                    this.fSelection = item.fLabel;
                }
                ++i;
            }
            this.combo.setItems(labels);
            if (this.fSelection != null) {
                this.combo.setText(this.fSelection);
            }
        }
    }

    protected Object doGetValue() {
        return this.fValue;
    }

    protected void doSetFocus() {
        this.combo.setText("");
        this.combo.setFocus();
    }

    protected void doSetValue(Object value) {
        this.fValue = value;
    }

    public void forwardFocusLost() {
        this.focusLost();
    }

    protected abstract LabelValuePair createComboBoxItem(String var1);

    public String getQuotesContext() {
        return this.eh.getQuotesContext();
    }

    public void setQuotesContext(String quotesContext) {
        this.eh.setQuotesContext(quotesContext);
    }

    public void setNeedQuotes(boolean value) {
        this.needQuotes = value;
    }

    public boolean getNeedQuotes() {
        return this.needQuotes;
    }

    public void setPairDataType(int dtype) {
        this.pairDataType = dtype;
    }

    public void setPairDataType(DataType dtype) {
        if (dtype instanceof PredefinedDataType) {
            int dataTypeInt;
            this.pairDataType = dataTypeInt = ((PredefinedDataType)dtype).getPrimitiveType().getValue();
        }
    }

    public int getPairDataType() {
        return this.pairDataType;
    }

    public String appendQuotes(String value) {
        if (this.needQuotes) {
            value = this.eh.appendQuotes(this.getPairDataType(), value);
        }
        return value;
    }

    private class ComboCellLayout
    extends Layout {
        private ComboCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            EditComboBoxCellEditor.this.combo.setBounds(0, 0, bounds.width, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point size = EditComboBoxCellEditor.this.combo.computeSize(-1, -1, force);
            size.x = editor.getBounds().width;
            return size;
        }
    }
}

