/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.Category;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepositoryConstants;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.LocalRepositoryNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPCategoryWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardSelectionPage;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizardCategoryFilter;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCategoryWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ProfileWizardProvider;
import org.eclipse.datatools.connectivity.ui.wizards.ICPWizard;
import org.eclipse.datatools.connectivity.ui.wizards.IWizardCategoryProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddProfileViewAction
extends Action
implements IHandler,
IViewActionDelegate {
    protected String categoryID;
    private IConnectionProfile parentProfile;
    private int returnCode;
    private IConnectionProfile addedProfile;
    private Shell shell;
    private boolean ignoreCategory = false;
    private boolean useSelection = true;
    private static String PROP_IGNORE_CATEGORY = "org.eclipse.datatools.connectivity.ui.ignoreCategory";
    private static String PROP_USE_SELECTION = "org.eclipse.datatools.connectivity.ui.useSelection";
    private transient ListenerList listenerList = null;

    public AddProfileViewAction() {
        this.setText(ConnectivityUIPlugin.getDefault().getResourceString("ServersView.action.newCP"));
    }

    public AddProfileViewAction(ICategory category) {
        this(category.getId());
    }

    public AddProfileViewAction(String categoryID) {
        this.categoryID = categoryID;
    }

    public void init(IViewPart viewpart) {
        this.shell = viewpart.getSite().getShell();
    }

    public void init(Shell parentShell) {
        this.shell = parentShell;
    }

    public final void addHandlerListener(IHandlerListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)listener);
    }

    public final void dispose() {
        this.listenerList = null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        String useSelectionValue;
        String ignoreCategoryValue;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part == null && event.getApplicationContext() != null) {
            return null;
        }
        if (part instanceof IViewPart) {
            this.init((IViewPart)part);
        }
        if ((ignoreCategoryValue = event.getParameter(PROP_IGNORE_CATEGORY)) != null && ignoreCategoryValue.trim().length() > 0) {
            this.ignoreCategory = Boolean.valueOf(ignoreCategoryValue);
        }
        if ((useSelectionValue = event.getParameter(PROP_USE_SELECTION)) != null && useSelectionValue.trim().length() > 0) {
            this.useSelection = Boolean.valueOf(useSelectionValue);
        }
        if (this.ignoreCategory) {
            this.categoryID = null;
        } else if (this.useSelection && (selection = part.getSite().getSelectionProvider().getSelection()) instanceof IStructuredSelection) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            if (sel instanceof ICategory) {
                this.setCategory((ICategory)sel);
            } else if (sel instanceof IConnectionProfile) {
                this.setCategory(((IConnectionProfile)sel).getCategory());
            } else {
                this.categoryID = null;
            }
        }
        Object wizard = this.getDefaultWizard(new String(), this.categoryID);
        if (wizard == null) {
            ViewerFilter[] wizardSelectionFilters = this.getApplicableFilters(this.categoryID);
            wizard = new NewCPWizard(wizardSelectionFilters, this.parentProfile);
        }
        WizardDialog wizardDialog = new WizardDialog(this.shell, wizard);
        wizardDialog.setBlockOnOpen(true);
        InternalProfileListener listener = new InternalProfileListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        this.returnCode = wizardDialog.open();
        this.addedProfile = listener.cachedProfile;
        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, false, false));
        return null;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)handlerListener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    public void run() {
        Object wizard;
        if (this.shell == null) {
            this.shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        }
        if ((wizard = this.getDefaultWizard(new String(), this.categoryID)) == null) {
            ViewerFilter[] wizardSelectionFilters = this.getApplicableFilters(this.categoryID);
            wizard = new NewCPWizard(wizardSelectionFilters, this.parentProfile);
        }
        WizardDialog wizardDialog = new WizardDialog(this.shell, wizard);
        wizardDialog.setBlockOnOpen(true);
        InternalProfileListener listener = new InternalProfileListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        this.returnCode = wizardDialog.open();
        this.addedProfile = listener.cachedProfile;
        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
    }

    private ViewerFilter[] getApplicableFilters(String categoryId) {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        filters.add(this.getCategoryFilter(categoryId));
        ViewerFilter[] moreFilters = this.getWizardSelectionFilters();
        if (moreFilters != null) {
            int i = 0;
            while (i < moreFilters.length) {
                filters.add(moreFilters[i]);
                ++i;
            }
        }
        return filters.toArray(new ViewerFilter[filters.size()]);
    }

    protected ViewerFilter getCategoryFilter(String categoryId) {
        return new NewCPWizardCategoryFilter(categoryId);
    }

    protected ViewerFilter[] getWizardSelectionFilters() {
        return null;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && action != null) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            if (sel instanceof LocalRepositoryNode) {
                action.setEnabled(true);
            }
            if (sel instanceof IConnectionProfile) {
                IManagedConnection imc = ((IConnectionProfile)sel).getManagedConnection(IConnectionProfileRepositoryConstants.REPOSITORY_CONNECTION_FACTORY_ID);
                if (imc != null && imc.isConnected()) {
                    IConnectionProfileRepository repo = (IConnectionProfileRepository)imc.getConnection().getRawConnection();
                    action.setEnabled(!repo.isReadOnly());
                }
            } else if (sel instanceof ICategory && sel instanceof Category) {
                IConnectionProfile profile = ((Category)sel).getRepositoryProfile();
                if (profile != null) {
                    IManagedConnection imc = profile.getManagedConnection(IConnectionProfileRepositoryConstants.REPOSITORY_CONNECTION_FACTORY_ID);
                    if (imc != null && imc.isConnected()) {
                        IConnectionProfileRepository repo = (IConnectionProfileRepository)imc.getConnection().getRawConnection();
                        action.setEnabled(!repo.isReadOnly());
                    }
                } else {
                    action.setEnabled(true);
                }
            }
        }
    }

    public void setCategory(ICategory category) {
        this.setCategory(category == null ? null : category.getId());
    }

    public void setCategory(String categoryID) {
        this.categoryID = categoryID;
    }

    public void setParentProfile(IConnectionProfile profile) {
        this.parentProfile = profile;
    }

    public IConnectionProfile getParentProfile() {
        return this.parentProfile;
    }

    public int getWizardReturnCode() {
        return this.returnCode;
    }

    public IConnectionProfile getAddedProfile() {
        return this.addedProfile;
    }

    private IWizard getDefaultWizard(String parentCategoryID, String categoryID) {
        IWizard wizard;
        Object wizardNode;
        ViewerFilter[] wizardNodeFilters;
        List wizardNodes = new CPWizardSelectionPage(new String()).getCategoryItems(parentCategoryID);
        ViewerFilter[] viewerFilterArray = wizardNodeFilters = categoryID != null ? this.getApplicableFilters(categoryID) : this.getWizardSelectionFilters();
        if (wizardNodeFilters != null && wizardNodeFilters.length > 0) {
            Iterator it = wizardNodes.iterator();
            block0: while (it.hasNext()) {
                wizardNode = it.next();
                int i = 0;
                while (i < wizardNodeFilters.length) {
                    ViewerFilter filter = wizardNodeFilters[i];
                    if (!filter.select(null, null, wizardNode)) {
                        it.remove();
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        if (wizardNodes == null || wizardNodes.size() == 0) {
            return null;
        }
        if (wizardNodes.size() > 1) {
            return null;
        }
        wizardNode = (CPWizardNode)wizardNodes.get(0);
        if (wizardNode instanceof CPCategoryWizardNode) {
            wizard = this.getDefaultWizard(((CPCategoryWizardNode)wizardNode).getProvider().getCategory(), null);
            if (wizard == null && (wizard = ((CPWizardNode)wizardNode).getWizard()) instanceof NewCategoryWizard) {
                ((NewCategoryWizard)wizard).initWizardCategory((IWizardCategoryProvider)((CPWizardNode)wizardNode).getProvider());
            }
        } else {
            wizard = ((CPWizardNode)wizardNode).getWizard();
            if (wizard instanceof ICPWizard) {
                ((ICPWizard)wizard).initProviderID(((ProfileWizardProvider)((CPWizardNode)wizardNode).getProvider()).getProfile());
                ((ICPWizard)wizard).setParentProfile(this.parentProfile);
            }
        }
        return wizard;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public boolean getIgnoreCategory() {
        return this.ignoreCategory;
    }

    public void setIgnoreCategory(boolean flag) {
        this.ignoreCategory = flag;
    }

    public boolean getUseSelection() {
        return this.useSelection;
    }

    public void setUseSelection(boolean flag) {
        this.useSelection = flag;
    }

    protected void fireHandlerChanged(HandlerEvent handlerEvent) {
        if (handlerEvent == null) {
            throw new NullPointerException();
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IHandlerListener listener = (IHandlerListener)listeners[i];
            listener.handlerChanged(handlerEvent);
            ++i;
        }
    }

    private class InternalProfileListener
    implements IProfileListener {
        protected IConnectionProfile cachedProfile;

        private InternalProfileListener() {
        }

        public void profileAdded(IConnectionProfile profile) {
            this.cachedProfile = profile;
        }

        public void profileChanged(IConnectionProfile profile) {
        }

        public void profileDeleted(IConnectionProfile profile) {
        }
    }
}

