/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.intropage;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.common.CollapseableSection;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.SOEUIPagePlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.intropage.IIntroHyperAction;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.intropage.ImageContainer;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.intropage.PredefinedIntroSection;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.ILogger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.framework.Bundle;

public class IntroductionSection
extends CollapseableSection {
    private String _pageExtensionId;
    private String _pageName;
    private ISchemaObjectEditorPage _page;
    private ILogger _log = SOEUIPagePlugin.getLogger(null);
    private List _images;

    public IntroductionSection(String pageExtensionId, FormToolkit toolkit, String title, Display display, int estyle) {
        super(toolkit, title, display, estyle);
        this._pageExtensionId = pageExtensionId;
        IConfigurationElement element = this.getExtension();
        if (element != null) {
            this._helpContextId = element.getAttribute("ContextHelpId");
        }
        this._images = new ArrayList();
    }

    public void createSectionContent(Composite parent) {
        this.getSection().setLayoutData((Object)new TableWrapData(256, 256));
        this.getSection().setLayout((Layout)new TableWrapLayout());
        parent.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 20;
        parent.setLayout((Layout)layout);
        IConfigurationElement element = this.getExtension();
        if (element != null) {
            this._helpContextId = element.getAttribute("ContextHelpId");
            this._pageName = element.getAttribute("Name");
            IConfigurationElement[] introElements = element.getChildren("introElement");
            int i = 0;
            while (i < introElements.length) {
                TableWrapData td;
                PredefinedIntroSection defSec;
                String icon = introElements[i].getAttribute("icon");
                String id = introElements[i].getAttribute("id");
                String heading = introElements[i].getAttribute("heading");
                String text = introElements[i].getAttribute("text");
                String hyperlink = introElements[i].getAttribute("hyperlink");
                String hyperlinkaction = introElements[i].getAttribute("hyperlinkaction");
                IIntroHyperAction hyperAction = null;
                String pluginNS = introElements[i].getDeclaringExtension().getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginNS);
                Image image = this.readImage(bundle, icon);
                if (id != null && (defSec = (PredefinedIntroSection)PredefinedIntroSection.SECTIONS.get(id)) != null) {
                    if (image == null && icon == null) {
                        image = defSec.getIcon().createImage();
                    }
                    if (heading == null) {
                        heading = defSec.getHeading();
                    }
                    if (text == null) {
                        text = defSec.getText();
                    }
                    if (hyperlink == null) {
                        hyperlink = defSec.getHyperlink();
                    }
                    if (hyperlinkaction == null) {
                        hyperAction = defSec.getHyperlinkAction();
                    }
                }
                if (image != null) {
                    ImageContainer ic = new ImageContainer(parent);
                    ic.setImage(image);
                    td = new TableWrapData();
                    td.rowspan = 2;
                    ic.setLayoutData(td);
                    this._images.add(image);
                } else {
                    Composite comp = new Composite(parent, 0);
                    td = new TableWrapData();
                    td.rowspan = 2;
                    comp.setLayoutData((Object)td);
                }
                if (heading != null && heading.trim().length() != 0) {
                    Label head = this._toolkit.createLabel(parent, heading);
                    head.setFont(JFaceResources.getHeaderFont());
                } else if (hyperlink != null && hyperlink.trim().length() != 0) {
                    Hyperlink hl = this._toolkit.createHyperlink(parent, hyperlink, 0);
                    if (hyperAction == null && hyperlinkaction != null) {
                        try {
                            hyperAction = (IIntroHyperAction)introElements[i].createExecutableExtension("hyperlinkaction");
                        }
                        catch (Exception e) {
                            this._log.error("IntroductionSection_create_intro_action", (Throwable)e);
                        }
                    }
                    if (hyperAction != null) {
                        hyperAction.setPage(this._page);
                    }
                    final IIntroHyperAction hAction = hyperAction;
                    hl.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            if (hAction != null) {
                                hAction.run();
                            }
                        }
                    });
                } else {
                    this._toolkit.createLabel(parent, "");
                }
                FormText txt = this._toolkit.createFormText(parent, false);
                txt.setText(text == null ? "" : text, false, false);
                ++i;
            }
        }
    }

    private IConfigurationElement getExtension() {
        if (this._pageExtensionId == null || this._pageExtensionId.trim().length() == 0) {
            return null;
        }
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages", "introductionPage", this._pageExtensionId);
        if (extension == null) {
            return null;
        }
        IConfigurationElement[] elements = extension.getConfigurationElements();
        return elements[0];
    }

    private Image readImage(Bundle bundle, String iconLoc) {
        if (bundle == null || iconLoc == null || bundle.getEntry(iconLoc) == null) {
            return null;
        }
        try {
            ImageDescriptor desp = ImageDescriptor.createFromURL((URL)bundle.getEntry(iconLoc));
            return desp.createImage();
        }
        catch (Exception ex) {
            this._log.error("IntroductionSection_error_read_image", (Throwable)ex);
            return null;
        }
    }

    public String getContextHelpId() {
        return this._helpContextId;
    }

    public String getPageName() {
        return this._pageName;
    }

    public void setPage(ISchemaObjectEditorPage _page) {
        this._page = _page;
    }

    public void dispose() {
        super.dispose();
        for (Image i : this._images) {
            i.dispose();
        }
    }
}

