"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var DEFAULT_REGEXP = /\.module\.(c|le|sa|sc)ss$/;
var isRelative = function (fileName) { return /^\.\.?($|[\\/])/.test(fileName); };
exports.createIsCSS = function (customMatcher) {
    if (customMatcher === void 0) { customMatcher = DEFAULT_REGEXP; }
    return function (fileName) { return customMatcher.test(fileName); };
};
exports.createIsRelativeCSS = function (isCSS) { return function (fileName) {
    return isCSS(fileName) && isRelative(fileName);
}; };
