/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.util;

import java.io.IOException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;

public class LaunchUtil {
    private static final ILog LOG = Platform.getLog(LaunchUtil.class);

    private LaunchUtil() {
    }

    public static void launchDartFile(String dartSdk, String dartFile) {
        Launch launch = new Launch(null, "run", null);
        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
        LaunchUtil.launchDartFile((ILaunch)launch, dartSdk, dartFile);
    }

    public static void launchDartFile(ILaunch launch, String dartSdk, String dartFile) {
        ProcessBuilder processBuilder = new ProcessBuilder(String.valueOf(dartSdk) + "/bin/dart", dartFile);
        Job job = Job.create((String)("Running " + dartFile), runnable -> {
            try {
                Process process = processBuilder.start();
                IProcess runtimeProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)Messages.Console_Name);
                launch.addProcess(runtimeProcess);
            }
            catch (IOException e) {
                LOG.log(StatusUtil.createError("Could not start Dart process", e));
            }
        });
        job.schedule();
    }

    public static void launchDartFile(String dartSdk, IPath dartFile) {
        LaunchUtil.launchDartFile(dartSdk, dartFile.toOSString());
    }
}

