/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dartboard.util.DartPreferences;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class DartUtil {
    public static final boolean IS_WINDOWS = "win32".equals(Platform.getOS());
    static ScopedPreferenceStore preferences = DartPreferences.getPreferenceStore();

    private DartUtil() {
    }

    public static String getExecutable(String name) {
        String dartSdk = preferences.getString("sdk_location");
        String result = String.valueOf(dartSdk) + File.separator + "bin" + File.separator + name;
        if (IS_WINDOWS) {
            return String.valueOf(result) + ".exe";
        }
        return result;
    }

    public static String getTool(String name) {
        String dartSdk = preferences.getString("sdk_location");
        String result = String.valueOf(dartSdk) + File.separator + "bin" + File.separator + name;
        if (IS_WINDOWS) {
            return String.valueOf(result) + ".bat";
        }
        return result;
    }

    public static Optional<Path> getDartLocation() throws IOException, InterruptedException {
        return DartUtil.getLocation("dart");
    }

    public static Optional<Path> getLocation(String program) throws IOException, InterruptedException {
        Path path = null;
        String[] command = IS_WINDOWS ? new String[]{"cmd", "/c", "where " + program} : new String[]{"/bin/bash", "-c", "which " + program};
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(command);
        Process process = processBuilder.start();
        process.waitFor();
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String location = reader.readLine();
            if (location != null) {
                path = Paths.get(location, new String[0]);
                path = path.toRealPath(new LinkOption[0]).getParent();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return Optional.ofNullable(path);
    }
}

