/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.launch;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.util.DartPreferences;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;

public class LaunchConfigTab
extends AbstractLaunchConfigurationTab {
    private static final ILog LOG = Platform.getLog(LaunchConfigTab.class);
    private Text textSdkLocation;
    private Text textMainClass;
    private Combo comboProject;
    private ScopedPreferenceStore preferences = DartPreferences.getPreferenceStore();
    private Image image;

    public LaunchConfigTab() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.dartboard");
        URL fileURL = bundle.getEntry("/icons/dart.png");
        ImageDescriptor createFromURL = ImageDescriptor.createFromURL((URL)fileURL);
        this.image = createFromURL.createImage();
    }

    public void createControl(Composite parent) {
        Group comp = new Group(parent, 0);
        this.setControl((Control)comp);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)comp);
        Label labelProject = new Label((Composite)comp, 0);
        labelProject.setText(Messages.Launch_Project);
        GridDataFactory.swtDefaults().applyTo((Control)labelProject);
        this.comboProject = new Combo((Composite)comp, 12);
        IProject[] iProjectArray = this.getProjectsInWorkspace();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.comboProject.add(project.getName());
            ++n2;
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.comboProject);
        this.comboProject.addModifyListener(event -> this.updateLaunchConfigurationDialog());
        Label labelSdkLocation = new Label((Composite)comp, 0);
        labelSdkLocation.setText(Messages.Preference_SDKLocation);
        GridDataFactory.swtDefaults().applyTo((Control)labelSdkLocation);
        this.textSdkLocation = new Text((Composite)comp, 0);
        this.textSdkLocation.setMessage(Messages.Launch_SDKLocation_Message);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.textSdkLocation);
        this.textSdkLocation.addModifyListener(event -> this.updateLaunchConfigurationDialog());
        Label labelMainClass = new Label((Composite)comp, 0);
        labelMainClass.setText(Messages.Launch_MainClass);
        GridDataFactory.swtDefaults().applyTo((Control)labelMainClass);
        this.textMainClass = new Text((Composite)comp, 0);
        this.textMainClass.setMessage(Messages.Launch_MainClass_Message);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.textMainClass);
        this.textMainClass.addModifyListener(event -> this.updateLaunchConfigurationDialog());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String defaultLocation = this.preferences.getString("sdk_location");
            String location = configuration.getAttribute("sdk_location", defaultLocation);
            this.textSdkLocation.setText(location);
            String mainClass = configuration.getAttribute("main_class", "main.dart");
            this.textMainClass.setText(mainClass);
            this.comboProject.setText(configuration.getAttribute("selected_project", ""));
            this.setDirty(true);
        }
        catch (CoreException e) {
            LOG.log(StatusUtil.createError("Couldn't initialize LaunchConfigTab", e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("sdk_location", this.textSdkLocation.getText());
        configuration.setAttribute("main_class", this.textMainClass.getText());
        configuration.setAttribute("selected_project", this.comboProject.getText());
    }

    public String getName() {
        return Messages.Launch_PageTitle;
    }

    private IProject[] getProjectsInWorkspace() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        return root.getProjects();
    }

    public Image getImage() {
        return this.image;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
    }
}

