/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlighting;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingPresenter;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingReconciler;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingWithOwnPreference;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightings;
import org.eclipse.cdt.internal.ui.text.CPresentationReconciler;
import org.eclipse.cdt.internal.ui.text.CSourceViewerScalableConfiguration;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.cdt.ui.text.ISemanticToken;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class SemanticHighlightingManager
implements IPropertyChangeListener {
    protected SemanticHighlightingPresenter fPresenter;
    private SemanticHighlightingReconciler fReconciler;
    protected SemanticHighlighting[] fSemanticHighlightings;
    protected HighlightingStyle[] fHighlightings;
    private CEditor fEditor;
    protected CSourceViewer fSourceViewer;
    protected IColorManager fColorManager;
    protected IPreferenceStore fPreferenceStore;
    protected CSourceViewerConfiguration fConfiguration;
    protected CPresentationReconciler fPresentationReconciler;
    private String fPreviewerLibraryDecls;

    public void install(CEditor editor, CSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore) {
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        this.fColorManager = colorManager;
        this.fPreferenceStore = preferenceStore;
        if (this.fEditor != null) {
            this.fConfiguration = new CSourceViewerScalableConfiguration(colorManager, preferenceStore, editor, "___c_partitioning");
            this.fPresentationReconciler = (CPresentationReconciler)this.fConfiguration.getPresentationReconciler((ISourceViewer)sourceViewer);
        } else {
            this.fConfiguration = null;
            this.fPresentationReconciler = null;
        }
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.isEnabled()) {
            this.enable();
        }
    }

    public void install(CSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore, String previewerLibraryDecls) {
        this.fPreviewerLibraryDecls = previewerLibraryDecls;
        this.install(null, sourceViewer, colorManager, preferenceStore);
    }

    private void enable() {
        this.initializeHighlightings();
        this.fPresenter = new SemanticHighlightingPresenter();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.fEditor != null) {
            this.fReconciler = new SemanticHighlightingReconciler();
            this.fReconciler.install(this.fEditor, (ISourceViewer)this.fSourceViewer, this.fPresenter, this.fSemanticHighlightings, this.fHighlightings);
        } else {
            this.fPresenter.updatePresentation(null, this.computePreviewerPositions(), new HighlightedPosition[0]);
        }
    }

    protected HighlightedPosition[] computePreviewerPositions() {
        CharArray previewCode = new CharArray(String.valueOf(this.fPreviewerLibraryDecls) + this.fSourceViewer.getDocument().get());
        GPPLanguage language = GPPLanguage.getDefault();
        InternalFileContent content = new InternalFileContent("<previewer>", previewCode);
        ScannerInfo scanInfo = new ScannerInfo();
        IncludeFileContentProvider fileCreator = IncludeFileContentProvider.getEmptyFilesProvider();
        IParserLogService log = ParserUtil.getParserLogService();
        IASTTranslationUnit tu = null;
        try {
            tu = language.getASTTranslationUnit((FileContent)content, (IScannerInfo)scanInfo, fileCreator, null, 0, log);
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            return new HighlightedPosition[0];
        }
        ArrayList<SemanticHighlighting> highlightings = new ArrayList<SemanticHighlighting>();
        SemanticHighlighting[] semanticHighlightingArray = this.fSemanticHighlightings;
        int n = this.fSemanticHighlightings.length;
        int n2 = 0;
        while (n2 < n) {
            SemanticHighlighting highlighting = semanticHighlightingArray[n2];
            if (SemanticHighlightings.isExternalSDKHighlighting(highlighting)) {
                highlightings.add(new PreviewerExternalSDKHighlighting());
            } else {
                highlightings.add(highlighting);
            }
            ++n2;
        }
        PreviewerPositionCollector collector = new PreviewerPositionCollector(highlightings.toArray(new SemanticHighlighting[highlightings.size()]), this.fHighlightings);
        tu.accept((ASTVisitor)collector);
        List<HighlightedPosition> positions = collector.getPositions();
        int libraryDeclsLen = this.fPreviewerLibraryDecls.length();
        ArrayList<HighlightedPosition> adjustedPositions = new ArrayList<HighlightedPosition>();
        for (HighlightedPosition position : positions) {
            if (position.offset < libraryDeclsLen) continue;
            position.offset -= libraryDeclsLen;
            adjustedPositions.add(position);
        }
        return adjustedPositions.toArray(new HighlightedPosition[adjustedPositions.size()]);
    }

    public void uninstall() {
        this.disable();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
        this.fEditor = null;
        this.fSourceViewer = null;
        this.fColorManager = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
        if (this.fSemanticHighlightings != null) {
            this.disposeHighlightings();
        }
    }

    protected boolean isEnabled() {
        return SemanticHighlightings.isEnabled(this.fPreferenceStore);
    }

    protected void initializeHighlightings() {
        this.fSemanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        this.fHighlightings = new HighlightingStyle[this.fSemanticHighlightings.length];
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            String underlineKey;
            String strikethroughKey;
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            String colorKey = SemanticHighlightings.getColorPreferenceKey(semanticHighlighting);
            this.addColor(colorKey);
            String boldKey = SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting);
            int style = this.fPreferenceStore.getBoolean(boldKey) ? 1 : 0;
            String italicKey = SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting);
            if (this.fPreferenceStore.getBoolean(italicKey)) {
                style |= 2;
            }
            if (this.fPreferenceStore.getBoolean(strikethroughKey = SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting))) {
                style |= 0x20000000;
            }
            if (this.fPreferenceStore.getBoolean(underlineKey = SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting))) {
                style |= 0x40000000;
            }
            boolean isEnabled = this.fPreferenceStore.getBoolean(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting));
            this.fHighlightings[i] = new HighlightingStyle(new TextAttribute(this.fColorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey)), null, style), isEnabled);
            ++i;
        }
    }

    protected void disposeHighlightings() {
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            this.removeColor(SemanticHighlightings.getColorPreferenceKey(this.fSemanticHighlightings[i]));
            ++i;
        }
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.handlePropertyChangeEvent(event);
    }

    protected boolean handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fPreferenceStore == null) {
            return false;
        }
        if (this.fConfiguration != null) {
            this.fConfiguration.handlePropertyChangeEvent(event);
        }
        if (SemanticHighlightings.affectsEnablement(this.fPreferenceStore, event)) {
            if (this.isEnabled()) {
                this.enable();
            } else {
                this.disable();
            }
        }
        if (!this.isEnabled()) {
            return false;
        }
        boolean refreshNeeded = false;
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            String colorKey = SemanticHighlightings.getColorPreferenceKey(semanticHighlighting);
            if (colorKey.equals(event.getProperty())) {
                this.adaptToTextForegroundChange(this.fHighlightings[i], event);
                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                refreshNeeded = true;
            } else {
                String boldKey = SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting);
                if (boldKey.equals(event.getProperty())) {
                    this.adaptToTextStyleChange(this.fHighlightings[i], event, 1);
                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                    refreshNeeded = true;
                } else {
                    String italicKey = SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting);
                    if (italicKey.equals(event.getProperty())) {
                        this.adaptToTextStyleChange(this.fHighlightings[i], event, 2);
                        this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                        refreshNeeded = true;
                    } else {
                        String strikethroughKey = SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting);
                        if (strikethroughKey.equals(event.getProperty())) {
                            this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x20000000);
                            this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                            refreshNeeded = true;
                        } else {
                            String underlineKey = SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting);
                            if (underlineKey.equals(event.getProperty())) {
                                this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x40000000);
                                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                refreshNeeded = true;
                            } else {
                                String enabledKey = SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting);
                                if (enabledKey.equals(event.getProperty())) {
                                    this.adaptToEnablementChange(this.fHighlightings[i], event);
                                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                    refreshNeeded = true;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (refreshNeeded && this.fReconciler != null) {
            this.fReconciler.refresh();
        }
        return refreshNeeded;
    }

    protected void adaptToEnablementChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        Object value = event.getNewValue();
        boolean eventValue = value instanceof Boolean ? (Boolean)value : "true".equals(value);
        highlighting.setEnabled(eventValue);
    }

    protected void adaptToTextForegroundChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if (color == null || !rgb.equals((Object)color.getRGB())) {
                this.fColorManager.unbindColor(property);
                this.fColorManager.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            TextAttribute oldAttr = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    protected void adaptToTextStyleChange(HighlightingStyle highlighting, PropertyChangeEvent event, int styleAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute oldAttr = highlighting.getTextAttribute();
        boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            highlighting.setTextAttribute(new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
        }
    }

    private void addColor(String colorKey) {
        if (this.fColorManager != null && colorKey != null && this.fColorManager.getColor(colorKey) == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            this.fColorManager.unbindColor(colorKey);
            this.fColorManager.bindColor(colorKey, rgb);
        }
    }

    private void removeColor(String colorKey) {
        this.fColorManager.unbindColor(colorKey);
    }

    public void refresh() {
        if (this.fReconciler != null) {
            this.fReconciler.refresh();
        }
    }

    public static class HighlightedPosition
    extends Position {
        private HighlightingStyle fStyle;
        private Object fLock;

        public HighlightedPosition(int offset, int length, HighlightingStyle highlighting, Object lock) {
            super(offset, length);
            this.fStyle = highlighting;
            this.fLock = lock;
        }

        public StyleRange createStyleRange() {
            int len = 0;
            if (this.fStyle.isEnabled()) {
                len = this.getLength();
            }
            TextAttribute textAttribute = this.fStyle.getTextAttribute();
            int style = textAttribute.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(this.getOffset(), len, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            return styleRange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEqual(int off, int len, HighlightingStyle highlighting) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && this.getOffset() == off && this.getLength() == len && this.fStyle == highlighting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isContained(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && off <= this.getOffset() && off + len >= this.getOffset() + this.getLength();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(off);
                super.setLength(len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLength(int length) {
            Object object = this.fLock;
            synchronized (object) {
                super.setLength(length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOffset(int offset) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            Object object = this.fLock;
            synchronized (object) {
                super.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undelete() {
            Object object = this.fLock;
            synchronized (object) {
                super.undelete();
            }
        }

        public HighlightingStyle getHighlighting() {
            return this.fStyle;
        }
    }

    public static class HighlightedRange
    extends Region {
        private String fKey;

        public HighlightedRange(int offset, int length, String key) {
            super(offset, length);
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public boolean equals(Object o) {
            return super.equals(o) && o instanceof HighlightedRange && this.fKey.equals(((HighlightedRange)((Object)o)).getKey());
        }

        public int hashCode() {
            return super.hashCode() | this.fKey.hashCode();
        }
    }

    public static class HighlightingStyle {
        private TextAttribute fTextAttribute;
        private boolean fIsEnabled;

        public HighlightingStyle(TextAttribute textAttribute, boolean isEnabled) {
            this.setTextAttribute(textAttribute);
            this.setEnabled(isEnabled);
        }

        public TextAttribute getTextAttribute() {
            return this.fTextAttribute;
        }

        public void setTextAttribute(TextAttribute textAttribute) {
            this.fTextAttribute = textAttribute;
        }

        public boolean isEnabled() {
            return this.fIsEnabled;
        }

        public void setEnabled(boolean isEnabled) {
            this.fIsEnabled = isEnabled;
        }
    }

    private static class PreviewerExternalSDKHighlighting
    extends SemanticHighlightingWithOwnPreference {
        private static final Set<String> fHarcodedSDKFunctions = new HashSet<String>();

        static {
            fHarcodedSDKFunctions.add("fprintf");
        }

        private PreviewerExternalSDKHighlighting() {
        }

        @Override
        public boolean consumes(ISemanticToken token) {
            IASTNode node = token.getNode();
            if (!(node instanceof IASTName)) {
                return false;
            }
            String name = new String(((IASTName)node).getSimpleID());
            return fHarcodedSDKFunctions.contains(name);
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return null;
        }

        @Override
        public String getDisplayName() {
            return null;
        }

        @Override
        public String getPreferenceKey() {
            return null;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }
    }

    private class PreviewerPositionCollector
    extends SemanticHighlightingReconciler.AbstractPositionCollector {
        private List<HighlightedPosition> fPositions;

        public PreviewerPositionCollector(SemanticHighlighting[] highlightings, HighlightingStyle[] highlightingStyles) {
            super(highlightings, highlightingStyles);
            this.fPositions = new ArrayList<HighlightedPosition>();
        }

        @Override
        protected void addPosition(int offset, int length, HighlightingStyle highlightingStyle) {
            this.fPositions.add(SemanticHighlightingManager.this.fPresenter.createHighlightedPosition(offset, length, highlightingStyle));
        }

        public List<HighlightedPosition> getPositions() {
            return this.fPositions;
        }
    }
}

