/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.snippet;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;

public class Snippet {
    private String[] replacementLines;
    private String display;
    private CompletionItemKind kind;

    public Snippet(String display, CompletionItemKind kind, String[] replacementLines) {
        this.replacementLines = replacementLines == null ? null : Arrays.copyOf(replacementLines, replacementLines.length);
        this.display = display;
        this.kind = kind;
    }

    public ICompletionProposal convertToCompletionProposal(int offset, LanguageServiceAccessor.LSPDocumentInfo info, String lineIndentation, Range textRange) {
        CompletionItem item = new CompletionItem();
        item.setLabel(this.display);
        item.setKind(this.kind);
        item.setSortText("zzzSnippet" + this.display);
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        IDocument document = info.getDocument();
        item.setTextEdit(Either.forLeft((Object)new TextEdit(textRange, this.createReplacement(lineIndentation))));
        return new LSCompletionProposal(document, offset, item, Snippet.getLanguageClient(info));
    }

    private static LanguageServer getLanguageClient(LanguageServiceAccessor.LSPDocumentInfo info) {
        try {
            return (LanguageServer)info.getInitializedLanguageClient().get();
        }
        catch (InterruptedException | ExecutionException e) {
            CorrosionPlugin.logError(e);
            return null;
        }
    }

    public boolean matchesPrefix(String prefix) {
        return this.display.startsWith(prefix);
    }

    private String createReplacement(String lineIndentation) {
        StringBuilder responseBuilder = new StringBuilder();
        if (this.replacementLines.length == 1) {
            return this.replacementLines[0];
        }
        if (this.replacementLines.length > 1) {
            String[] stringArray = this.replacementLines;
            int n = this.replacementLines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (responseBuilder.length() == 0) {
                    responseBuilder.append(line);
                } else {
                    responseBuilder.append('\n');
                    responseBuilder.append(lineIndentation);
                    responseBuilder.append(line);
                }
                ++n2;
            }
        }
        return responseBuilder.toString();
    }
}

