/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponent;
import org.eclipse.egit.ui.internal.dialogs.ICommitMessageComponentNotifications;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.egit.ui.internal.staging.CommitMessagePreviewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jgit.lib.CommitConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class CommitMessageEditorDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION_NAME = "org.eclipse.egit.ui.COMMIT_MESSAGE_EDITOR_DIALOG_SECTION";
    private static final Pattern CHANGE_ID = Pattern.compile("^Change-Id: I[0-9a-fA-F]{40}$", 8);
    private Repository repository;
    private SpellcheckableMessageArea messageArea;
    private Composite previewArea;
    private CommitMessagePreviewer previewer;
    private CommitMessageComponent commitComponent;
    private Composite commitMessageSection;
    private StackLayout previewLayout;
    private IAction addChangeIdAction;
    private String title;
    private String okButtonLabel;
    private String cancelButtonLabel;
    private String commitMessage;
    private boolean useChangeId;
    private CommitConfig.CleanupMode mode;
    private char commentChar;

    public CommitMessageEditorDialog(Shell parentShell, Repository repository, String commitMessage, CommitConfig.CleanupMode mode, char commentChar) {
        this(parentShell, repository, commitMessage, mode, commentChar, UIText.CommitMessageEditorDialog_EditCommitMessageTitle);
    }

    public CommitMessageEditorDialog(Shell parentShell, Repository repository, String commitMessage, CommitConfig.CleanupMode mode, char commentChar, String title) {
        this(parentShell, repository, commitMessage, mode, commentChar, UIText.CommitMessageEditorDialog_OkButton, IDialogConstants.CANCEL_LABEL);
        this.title = title;
    }

    public CommitMessageEditorDialog(Shell parentShell, Repository repository, String commitMessage, CommitConfig.CleanupMode mode, char commentChar, String okButtonLabel, String cancelButtonLabel) {
        super(parentShell);
        this.repository = repository;
        this.commitMessage = commitMessage;
        this.title = UIText.CommitMessageEditorDialog_EditCommitMessageTitle;
        this.okButtonLabel = okButtonLabel;
        this.cancelButtonLabel = cancelButtonLabel;
        this.mode = mode;
        this.commentChar = commentChar;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.setTitle(UIText.RebaseInteractiveHandler_EditMessageDialogTitle);
        this.setMessage(MessageFormat.format(UIText.RebaseInteractiveHandler_EditMessageDialogText, Character.toString(this.commentChar)));
        StoredConfig config = this.repository.getConfig();
        this.commitMessageSection = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.commitMessageSection);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.commitMessageSection);
        Composite titleBar = new Composite(this.commitMessageSection, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)titleBar);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(titleBar);
        final Label areaTitle = new Label(titleBar, 0);
        areaTitle.setText(UIText.StagingView_CommitMessage);
        areaTitle.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)areaTitle);
        Composite commitMessageToolbarComposite = new Composite(titleBar, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)commitMessageToolbarComposite);
        RowLayout layout = new RowLayout();
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        commitMessageToolbarComposite.setLayout((Layout)layout);
        ToolBarManager commitMessageToolBarManager = new ToolBarManager(0x800100);
        Action previewAction = new Action(UIText.StagingView_Preview_Commit_Message, 2){

            public void run() {
                if (this.isChecked()) {
                    CommitMessageEditorDialog.this.previewLayout.topControl = CommitMessageEditorDialog.this.previewArea;
                    areaTitle.setText(UIText.StagingView_CommitMessagePreview);
                    CommitMessageEditorDialog.this.previewer.setText(CommitMessageEditorDialog.this.repository, CommitMessageEditorDialog.this.messageArea.getCommitMessage());
                } else {
                    CommitMessageEditorDialog.this.previewLayout.topControl = CommitMessageEditorDialog.this.messageArea;
                    areaTitle.setText(UIText.StagingView_CommitMessage);
                }
                areaTitle.requestLayout();
                CommitMessageEditorDialog.this.previewLayout.topControl.getParent().layout(true, true);
                CommitMessageEditorDialog.this.commitMessageSection.redraw();
                if (!this.isChecked()) {
                    CommitMessageEditorDialog.this.messageArea.setFocus();
                }
            }
        };
        previewAction.setImageDescriptor(UIIcons.ELCL16_PREVIEW);
        commitMessageToolBarManager.add((IAction)previewAction);
        commitMessageToolBarManager.add((IContributionItem)new Separator());
        Action signOffAction = new Action(UIText.StagingView_Add_Signed_Off_By, 2){

            public void run() {
                CommitMessageEditorDialog.this.commitComponent.setSignedOffButtonSelection(this.isChecked());
            }
        };
        signOffAction.setImageDescriptor(UIIcons.SIGNED_OFF);
        commitMessageToolBarManager.add((IAction)signOffAction);
        this.addChangeIdAction = new Action(UIText.StagingView_Add_Change_ID, 2){

            public void run() {
                CommitMessageEditorDialog.this.commitComponent.setChangeIdButtonSelection(this.isChecked());
            }
        };
        this.addChangeIdAction.setImageDescriptor(UIIcons.GERRIT);
        boolean hasChangeId = this.hasChangeIdFooter(this.commitMessage);
        this.addChangeIdAction.setChecked(hasChangeId);
        this.addChangeIdAction.setEnabled(hasChangeId || GerritUtil.getCreateChangeId((Config)config));
        commitMessageToolBarManager.add(this.addChangeIdAction);
        ToolBar tb = commitMessageToolBarManager.createControl(commitMessageToolbarComposite);
        tb.setBackground(null);
        Composite commitMessageTextComposite = new Composite(this.commitMessageSection, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)commitMessageTextComposite);
        this.previewLayout = new StackLayout();
        commitMessageTextComposite.setLayout((Layout)this.previewLayout);
        this.messageArea = new SpellcheckableMessageArea(commitMessageTextComposite, "", 0);
        this.messageArea.setData("FormWidgetFactory.drawBorder", "textBorder");
        CommitConfig.CleanupMode cleanup = this.mode;
        if (cleanup == null || CommitConfig.CleanupMode.DEFAULT.equals((Object)cleanup)) {
            cleanup = CommitConfig.CleanupMode.STRIP;
        }
        this.messageArea.setCleanupMode(cleanup, this.commentChar);
        String msg = Utils.normalizeLineEndings((String)this.commitMessage).replaceAll("\n", Text.DELIMITER);
        this.messageArea.setText(msg);
        Point size = this.messageArea.getTextWidget().getSize();
        int minHeight = this.messageArea.getTextWidget().getLineHeight() * 3;
        GridDataFactory.fillDefaults().grab(true, true).hint(size).minSize(size.x, minHeight).align(4, 4).applyTo((Control)this.messageArea);
        this.previewArea = new Composite(commitMessageTextComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.previewArea);
        this.previewArea.setLayout((Layout)new FillLayout());
        this.previewArea.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.previewer = new CommitMessagePreviewer();
        this.previewer.createControl(this.previewArea);
        this.previewLayout.topControl = this.messageArea;
        this.messageArea.setFocus();
        Text hiddenAuthor = new Text(composite, 0);
        GridDataFactory.fillDefaults().exclude(true).applyTo((Control)hiddenAuthor);
        hiddenAuthor.setVisible(false);
        Text hiddenCommitter = new Text(composite, 0);
        GridDataFactory.fillDefaults().exclude(true).applyTo((Control)hiddenCommitter);
        hiddenCommitter.setVisible(false);
        UserConfig cfg = (UserConfig)config.get(UserConfig.KEY);
        String person = String.valueOf(cfg.getCommitterName()) + " <" + cfg.getCommitterEmail() + '>';
        hiddenAuthor.setText(person);
        hiddenCommitter.setText(person);
        this.commitComponent = new CommitMessageComponent(this.repository, new ICommitMessageComponentNotifications((IAction)signOffAction){
            private final /* synthetic */ IAction val$signOffAction;
            {
                this.val$signOffAction = iAction;
            }

            @Override
            public void updateSignedOffToggleSelection(boolean selection) {
                this.val$signOffAction.setChecked(selection);
            }

            @Override
            public void updateSignCommitToggleSelection(boolean selection) {
            }

            @Override
            public void updateChangeIdToggleSelection(boolean selection) {
                CommitMessageEditorDialog.this.addChangeIdAction.setChecked(selection);
            }

            @Override
            public void statusUpdated() {
            }
        });
        this.commitComponent.attachControls(this.messageArea, hiddenAuthor, hiddenCommitter);
        this.commitComponent.updateSignedOffAndChangeIdButton();
        return composite;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION_NAME);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION_NAME);
        }
        return section;
    }

    protected void okPressed() {
        this.commitMessage = this.messageArea.getCommitMessage();
        this.useChangeId = this.addChangeIdAction.isChecked();
        super.okPressed();
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public boolean isWithChangeId() {
        return this.useChangeId;
    }

    private boolean hasChangeIdFooter(String message) {
        int footer = CommonUtils.getFooterOffset(message);
        return footer > 0 && CHANGE_ID.matcher(message).find(footer);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.okButtonLabel, true);
        this.createButton(parent, 1, this.cancelButtonLabel, false);
    }
}

