/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.launch;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.launch.CargoArgs;
import org.eclipse.corrosion.launch.RLSRunCommand;
import org.eclipse.corrosion.launch.RustLaunchDelegateTools;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.lsp4e.command.LSPCommandHandler;
import org.eclipse.lsp4j.Command;
import org.eclipse.osgi.util.NLS;

public class LaunchHandler
extends LSPCommandHandler {
    private static final Pattern ENV_SPLITTER = Pattern.compile("=");
    private static final Predicate<String> NOT_EMPTY = LaunchHandler.not(String::isEmpty);

    private static <T> Predicate<T> not(Predicate<T> p) {
        return p.negate();
    }

    public Object execute(ExecutionEvent event, Command command, IPath context) throws ExecutionException {
        IProject project;
        Path cargoRegistry = new Path("/.cargo/registry");
        if (cargoRegistry.isPrefixOf(context)) {
            RustLaunchDelegateTools.openError(Messages.LaunchHandler_unableToLaunch, Messages.LaunchHandler_launchingFromCargoRegistryUnsupported);
            return null;
        }
        Optional<RLSRunCommand> runCommand = RLSRunCommand.fromLSPCommand(command);
        if (!runCommand.isPresent()) {
            String msg = NLS.bind((String)Messages.LaunchHandler_unableToLaunchCommand, (Object)command);
            CorrosionPlugin.logError(Status.error((String)msg));
        }
        if ((project = ResourcesPlugin.getWorkspace().getRoot().getFile(context).getProject()).exists()) {
            Optional<RLSRunCommand> cargoRunCommand = runCommand.filter(LaunchHandler::isCargoBin).filter(LaunchHandler::isTestArg);
            cargoRunCommand.ifPresent(c -> LaunchHandler.createAndStartCargoTest(c, project));
            if (!cargoRunCommand.isPresent()) {
                String msg = NLS.bind((String)Messages.LaunchHandler_unableToLaunchCommand, (Object)command);
                CorrosionPlugin.logError(Status.error((String)msg));
            }
            return null;
        }
        RustLaunchDelegateTools.openError(Messages.LaunchHandler_unableToLaunch, Messages.LaunchHandler_unsupportedProjectLocation);
        return null;
    }

    private static boolean isCargoBin(RLSRunCommand command) {
        return Objects.equals(command.binary, "cargo") || Objects.equals(command.binary, "cargo.exe");
    }

    private static boolean isTestArg(RLSRunCommand runCommand) {
        return runCommand.args.length > 0 && Objects.equals(runCommand.args[0], "test");
    }

    private static void createAndStartCargoTest(RLSRunCommand command, IProject project) {
        CargoArgs args = CargoArgs.fromAllArguments(command.args);
        Map<String, String> envMap = command.env;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.corrosion.test.CargoTestDelegate");
        try {
            ILaunchConfiguration[] launchConfigurations = manager.getLaunchConfigurations(type);
            Set<Map.Entry<String, String>> envMapEntries = envMap.entrySet();
            ILaunchConfiguration launchConfig = Arrays.stream(launchConfigurations).filter(l -> LaunchHandler.matchesTestLaunchConfig(l, project, args, envMapEntries)).findAny().orElseGet(() -> LaunchHandler.createCargoLaunchConfig(manager, type, project, args, envMap));
            if (launchConfig != null) {
                DebugUITools.launch((ILaunchConfiguration)launchConfig, (String)"run");
            }
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
        }
    }

    private static ILaunchConfiguration createCargoLaunchConfig(ILaunchManager manager, ILaunchConfigurationType cargoLaunchType, IProject project, CargoArgs args, Map<String, String> envMap) {
        try {
            String projectName = project.getName();
            String optionsString = LaunchHandler.toSpaceSeparatedString(args.options);
            String argumentsString = LaunchHandler.toSpaceSeparatedString(args.arguments);
            String launchConfigName = LaunchHandler.createLaunchConfigName(manager, projectName, args.command, optionsString, argumentsString);
            ILaunchConfigurationWorkingCopy launchWorkingCopy = cargoLaunchType.newInstance(null, launchConfigName);
            launchWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", projectName);
            launchWorkingCopy.setAttribute("OPTIONS", optionsString);
            launchWorkingCopy.setAttribute("ARGUMENTS", argumentsString);
            launchWorkingCopy.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, envMap);
            launchWorkingCopy.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", projectName);
            return launchWorkingCopy;
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
            return null;
        }
    }

    private static String toSpaceSeparatedString(List<String> strings) {
        return strings.stream().collect(Collectors.joining(" "));
    }

    private static String createLaunchConfigName(ILaunchManager manager, String projectName, String command, String optionsString, String argumentsString) {
        String nameSuffix = Stream.of(command, optionsString, "--", argumentsString).filter(NOT_EMPTY).collect(Collectors.joining(" ", " [", "]"));
        String nameWithSuffix = String.valueOf(projectName) + nameSuffix;
        return manager.generateLaunchConfigurationName(nameWithSuffix);
    }

    private static boolean matchesTestLaunchConfig(ILaunchConfiguration launchConfig, IProject cmdProject, CargoArgs cmdArgs, Set<Map.Entry<String, String>> cmdEnvEntries) {
        block10: {
            block9: {
                block8: {
                    try {
                        String project = launchConfig.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                        if (project.equals(cmdProject.getName())) break block8;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                String optionsStr = launchConfig.getAttribute("OPTIONS", "");
                String[] options = new String[]{};
                if (!optionsStr.isEmpty()) {
                    options = LaunchHandler.substituteVariablesAndSplit(optionsStr);
                }
                if (cmdArgs.options.equals(Arrays.asList(options))) break block9;
                return false;
            }
            String argumentsStr = launchConfig.getAttribute("ARGUMENTS", "");
            String[] arguments = new String[]{};
            if (!argumentsStr.isEmpty()) {
                arguments = LaunchHandler.substituteVariablesAndSplit(argumentsStr);
            }
            if (cmdArgs.arguments.equals(Arrays.asList(arguments))) break block10;
            return false;
        }
        String[] envArgs = DebugPlugin.getDefault().getLaunchManager().getEnvironment(launchConfig);
        Set envEntries = Collections.emptySet();
        if (envArgs != null) {
            envEntries = Arrays.stream(envArgs).map(LaunchHandler::splitToEntry).collect(Collectors.toSet());
        }
        return envEntries.containsAll(cmdEnvEntries);
    }

    private static String[] substituteVariablesAndSplit(String argumentsStr) throws CoreException {
        return RustLaunchDelegateTools.performVariableSubstitution(argumentsStr).split("\\s+");
    }

    private static Map.Entry<String, String> splitToEntry(String s) {
        String[] split = ENV_SPLITTER.split(s, 2);
        String key = split[0];
        String value = "";
        if (split.length > 1) {
            value = split[1];
        }
        return new AbstractMap.SimpleEntry<String, String>(key, value);
    }
}

