/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.compare;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Collections;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.UnitOfWork;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class LocalNonWorkspaceTypedElement
extends LocalResourceTypedElement
implements GitInfo {
    @NonNull
    private final IPath path;
    @NonNull
    private final Repository repository;
    private final boolean isSymlink;
    private final boolean isFile;
    private boolean exists;
    private boolean fDirty;
    private long timestamp;
    private boolean useSharedDocument = true;
    private EditableSharedDocumentAdapter sharedDocumentAdapter;
    private EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener;
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private byte[] modifiedContent;

    public LocalNonWorkspaceTypedElement(@NonNull Repository repository, @NonNull IPath path) {
        super((IResource)ROOT.getFile(path));
        this.path = path;
        this.repository = repository;
        File file = path.toFile();
        this.isSymlink = Files.isSymbolicLink(file.toPath());
        this.isFile = file.isFile();
        boolean bl = this.exists = this.isFile || this.isSymlink || file.exists();
        if (this.exists) {
            this.timestamp = file.lastModified();
        }
    }

    public InputStream getContents() throws CoreException {
        if (this.modifiedContent != null) {
            return new ByteArrayInputStream(this.modifiedContent);
        }
        return this.createStream();
    }

    public void setContent(byte[] contents) {
        this.fDirty = true;
        this.modifiedContent = contents;
        this.fireContentChanged();
    }

    public byte[] getContent() {
        if (this.modifiedContent == null) {
            try {
                InputStream is = this.createStream();
                this.modifiedContent = Utilities.readBytes((InputStream)is);
            }
            catch (CoreException e) {
                Activator.handleStatus(e.getStatus(), false);
            }
        }
        return this.modifiedContent;
    }

    public void discardBuffer() {
        super.discardBuffer();
        if (this.sharedDocumentAdapter != null) {
            this.sharedDocumentAdapter.releaseBuffer();
        }
        this.modifiedContent = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InputStream createStream() throws CoreException {
        IPath subPath;
        block4: {
            if (!this.exists) return null;
            File file = this.path.toFile();
            this.timestamp = file.lastModified();
            if (this.isSymlink) {
                String symLink = FileUtils.readSymLink((File)file);
                return new ByteArrayInputStream(Constants.encode((String)symLink));
            }
            if (!file.isDirectory()) return Files.newInputStream(file.toPath(), new OpenOption[0]);
            subPath = ResourceUtil.getRepositoryRelativePath((IPath)this.path, (Repository)this.repository);
            if (subPath != null && !subPath.isEmpty()) break block4;
            return null;
        }
        try {
            return (InputStream)UnitOfWork.run((Repository)this.repository, () -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        catch (IOException | UnsupportedOperationException e) {
            Activator.error(e.getMessage(), e);
        }
        return null;
    }

    public boolean isEditable() {
        return this.exists && (this.isFile || this.isSymlink);
    }

    public long getModificationDate() {
        return this.timestamp;
    }

    public boolean isSynchronized() {
        return this.path.toFile().lastModified() == this.timestamp;
    }

    public void update() {
        this.exists = this.path.toFile().exists();
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isSharedDocumentsEnable() {
        return this.useSharedDocument && !this.isSymlink && this.isEditable();
    }

    public void enableSharedDocument(boolean enablement) {
        this.useSharedDocument = enablement;
    }

    private void refreshTimestamp() {
        this.timestamp = this.path.toFile().lastModified();
    }

    public void commit(IProgressMonitor monitor) throws CoreException {
        if (this.isDirty()) {
            if (this.isConnected()) {
                super.commit(monitor);
            } else {
                File file = this.path.toFile();
                try {
                    try {
                        byte[] contents = this.getContent();
                        if (this.isSymlink) {
                            String sp = new String(contents, StandardCharsets.UTF_8).trim();
                            if (sp.indexOf(10) > 0) {
                                sp = sp.substring(0, sp.indexOf(10)).trim();
                            }
                            if (!sp.isEmpty()) {
                                boolean wasBrokenLink = !file.exists();
                                java.nio.file.Path link = FileUtils.createSymLink((File)file, (String)sp);
                                this.updateLinkResource(wasBrokenLink, link);
                            }
                        } else {
                            Throwable throwable = null;
                            Object var5_9 = null;
                            try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                                out.write(contents);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        this.fDirty = false;
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.egit.ui", UIText.LocalNonWorkspaceTypedElement_errorWritingContents, (Throwable)e));
                    }
                }
                finally {
                    this.fireContentChanged();
                    this.updateGitState();
                }
            }
            this.refreshTimestamp();
        }
    }

    private void updateLinkResource(boolean wasBroken, java.nio.file.Path link) {
        boolean brokenNow;
        boolean bl = brokenNow = !Files.exists(link, new LinkOption[0]);
        if (brokenNow == wasBroken) {
            return;
        }
        IPath parentPath = this.path.removeLastSegments(1);
        final IContainer parent = ResourceUtil.getContainerForLocation((IPath)parentPath, (boolean)true);
        if (parent != null) {
            WorkspaceJob job = new WorkspaceJob("Refreshing " + parentPath){

                public IStatus runInWorkspace(IProgressMonitor m) throws CoreException {
                    parent.refreshLocal(1, m);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private void updateGitState() {
        RepositoryMapping mapping;
        Repository myRepository = this.repository;
        boolean updated = false;
        if (!myRepository.isBare()) {
            updated = this.refreshRepositoryState(myRepository);
        }
        if (!updated && (mapping = RepositoryMapping.getMapping((IPath)this.path)) != null) {
            mapping.getRepository().fireEvent((RepositoryEvent)new IndexChangedEvent(true));
        }
    }

    private boolean refreshRepositoryState(@NonNull Repository repo) {
        Path repositoryRoot = new Path(repo.getWorkTree().getPath());
        IPath relativePath = this.path.makeRelativeTo((IPath)repositoryRoot);
        IndexDiffCacheEntry indexDiffCacheForRepository = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repo);
        if (indexDiffCacheForRepository != null) {
            indexDiffCacheForRepository.refreshFiles(Collections.singleton(relativePath.toString()));
            return true;
        }
        return false;
    }

    public synchronized boolean isDirty() {
        return this.fDirty || this.sharedDocumentAdapter != null && this.sharedDocumentAdapter.hasBufferedContents();
    }

    public boolean isConnected() {
        return this.sharedDocumentAdapter != null && this.sharedDocumentAdapter.isConnected();
    }

    public boolean saveDocument(boolean overwrite, IProgressMonitor monitor) throws CoreException {
        if (this.isConnected()) {
            IEditorInput input = this.sharedDocumentAdapter.getDocumentKey((Object)this);
            this.sharedDocumentAdapter.saveDocument(input, overwrite, monitor);
            this.updateGitState();
            this.refreshTimestamp();
            return true;
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISharedDocumentAdapter.class) {
            if (this.isSharedDocumentsEnable()) {
                return this.getSharedDocumentAdapter();
            }
            return null;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void setSharedDocumentListener(EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener) {
        this.sharedDocumentListener = sharedDocumentListener;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LocalNonWorkspaceTypedElement other = (LocalNonWorkspaceTypedElement)((Object)obj);
        return this.path.equals((Object)other.path);
    }

    private synchronized ISharedDocumentAdapter getSharedDocumentAdapter() {
        if (this.sharedDocumentAdapter == null) {
            this.sharedDocumentAdapter = new EditableSharedDocumentAdapter(new EditableSharedDocumentAdapter.ISharedDocumentAdapterListener(){

                public void handleDocumentConnected() {
                    LocalNonWorkspaceTypedElement.this.refreshTimestamp();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentConnected();
                    }
                }

                public void handleDocumentFlushed() {
                    LocalNonWorkspaceTypedElement.this.fireContentChanged();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentFlushed();
                    }
                }

                public void handleDocumentDeleted() {
                    LocalNonWorkspaceTypedElement.this.update();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentDeleted();
                    }
                }

                public void handleDocumentSaved() {
                    LocalNonWorkspaceTypedElement.this.updateGitState();
                    LocalNonWorkspaceTypedElement.this.refreshTimestamp();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentSaved();
                    }
                }

                public void handleDocumentDisconnected() {
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentDisconnected();
                    }
                }
            }){

                public IEditorInput getDocumentKey(Object element) {
                    IFileStore store;
                    if (element == LocalNonWorkspaceTypedElement.this && (store = EFS.getLocalFileSystem().getStore(LocalNonWorkspaceTypedElement.this.path)) != null) {
                        return new FakeResourceFileStoreEditorInput(store, LocalNonWorkspaceTypedElement.this.getResource());
                    }
                    return super.getDocumentKey(element);
                }

                public void connect(IDocumentProvider provider, IEditorInput documentKey) throws CoreException {
                    if (documentKey instanceof FakeResourceFileStoreEditorInput) {
                        FakeResourceFileStoreEditorInput input = (FakeResourceFileStoreEditorInput)documentKey;
                        try {
                            input.setResource(null);
                            super.connect(provider, (IEditorInput)input);
                        }
                        finally {
                            input.setResource(LocalNonWorkspaceTypedElement.this.getResource());
                        }
                    } else {
                        super.connect(provider, documentKey);
                    }
                }
            };
        }
        return this.sharedDocumentAdapter;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getGitPath() {
        IPath relativePath = ResourceUtil.getRepositoryRelativePath((IPath)this.path, (Repository)this.repository);
        return relativePath == null ? null : relativePath.toPortableString();
    }

    public GitInfo.Source getSource() {
        return GitInfo.Source.WORKING_TREE;
    }

    public AnyObjectId getCommitId() {
        return null;
    }

    private static /* synthetic */ BaseRepositoryBuilder lambda$1() {
        return RepositoryCache.INSTANCE.getBuilder(true, true);
    }

    private static class FakeResourceFileStoreEditorInput
    extends FileStoreEditorInput {
        private IResource resource;

        public FakeResourceFileStoreEditorInput(IFileStore store, IResource resource) {
            super(store);
            this.resource = resource;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if ((adapter == IFile.class || adapter == IResource.class) && this.resource != null && adapter.isInstance(this.resource)) {
                return adapter.cast(this.resource);
            }
            return (T)super.getAdapter(adapter);
        }

        public void setResource(IResource resource) {
            this.resource = resource;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object o) {
            return super.equals(o);
        }
    }
}

