/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.ResetActionHandler;
import org.eclipse.egit.ui.internal.actions.ResetMenu;
import org.eclipse.egit.ui.internal.repository.SelectResetTypePage;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.Ref;

public class ResetCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode<?>> {
    public static final String ID = "org.eclipse.egit.ui.team.Reset";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String currentBranch;
        final RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        try {
            currentBranch = node.getRepository().getFullBranch();
        }
        catch (IOException e1) {
            throw new ExecutionException(e1.getMessage(), (Throwable)e1);
        }
        if (!(node.getObject() instanceof Ref)) {
            return new ResetActionHandler().execute(event);
        }
        final Ref targetBranch = (Ref)node.getObject();
        final String repoName = RepositoryUtil.getInstance().getRepositoryName(node.getRepository());
        Wizard wiz = new Wizard(){

            public void addPages() {
                this.addPage((IWizardPage)new SelectResetTypePage(repoName, node.getRepository(), currentBranch, targetBranch.getName()));
                this.setWindowTitle(UIText.ResetCommand_WizardTitle);
            }

            public boolean performFinish() {
                ResetCommand.ResetType resetType = ((SelectResetTypePage)this.getPages()[0]).getResetType();
                ResetMenu.performReset(this.getShell(), node.getRepository(), targetBranch.getObjectId(), resetType);
                return true;
            }
        };
        WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)wiz);
        dlg.setHelpAvailable(false);
        dlg.open();
        return null;
    }
}

