/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.corrosion.resources.ResourceLookup;
import org.eclipse.corrosion.sourcelookup.CargoAbsolutePathSourceContainer;
import org.eclipse.corrosion.sourcelookup.CargoCommonSourceLookupDirector;
import org.eclipse.corrosion.sourcelookup.CargoProjectSourceContainer;
import org.eclipse.corrosion.sourcelookup.CargoSourceLookupDirector;
import org.eclipse.corrosion.sourcelookup.CargoSourceUtils;
import org.eclipse.corrosion.sourcelookup.ICargoSourceLocation;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class CorrosionPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.corrosion";
    private static BundleContext context;
    public static final int INTERNAL_ERROR = 1000;
    private static CorrosionPlugin plugin;
    private ServiceTracker<IRetrieveFileTransferFactory, IRetrieveFileTransferFactory> retrievalFactoryTracker;
    public static final String CONTENT_TYPE_CORROSION_RUST = "org.eclipse.corrosion.rust";
    public static final String CONTENT_TYPE_CORROSION_TOML = "org.eclipse.corrosion.toml";
    public static final String CONTENT_TYPE_CORROSION_MANIFEST = "org.eclipse.corrosion.manifest";
    public static final String PREF_SOURCE_LOCATIONS = "org.eclipse.corrosionCargo.Source.source_locations";
    public static final String PREF_COMMON_SOURCE_CONTAINERS = "org.eclipse.corrosion.Cargo.common_source_containers";
    public static final String PREF_DEFAULT_SOURCE_CONTAINERS = "org.eclipse.corrosion.Cargo.default_source_containers";
    private CargoCommonSourceLookupDirector fCommonSourceLookupDirector;

    private static synchronized void setSharedInstance(CorrosionPlugin newValue) {
        plugin = newValue;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CorrosionPlugin.context = context;
        CorrosionPlugin.setSharedInstance(this);
        ResourceLookup.startup();
        this.initializeCommonSourceLookupDirector();
        Job.create((String)"Import .cargo in workspace", monitor -> CargoTools.ensureDotCargoImportedAsProject(monitor)).schedule();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.retrievalFactoryTracker != null) {
            this.retrievalFactoryTracker.close();
        }
        CorrosionPlugin.setSharedInstance(null);
        this.disposeCommonSourceLookupDirector();
        ResourceLookup.shutdown();
        super.stop(context);
    }

    public static BundleContext getContext() {
        return context;
    }

    public static CorrosionPlugin getDefault() {
        return plugin;
    }

    public static void logError(String message) {
        CorrosionPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 1000, message, null));
    }

    public static void logError(Throwable t) {
        CorrosionPlugin.logError((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static void logError(IStatus s) {
        CorrosionPlugin.getDefault().getLog().log(s);
    }

    public static void showError(String title, String message, Exception exception) {
        CorrosionPlugin.showError(title, String.valueOf(message) + '\n' + exception.getLocalizedMessage());
    }

    public static void showError(String title, String message) {
        Display.getDefault().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, message, 1, 0, new String[]{IDialogConstants.OK_LABEL});
            dialog.setBlockOnOpen(false);
            dialog.open();
        });
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        CorrosionPlugin.declareRegistryImage(reg, "images/cargo.png");
        CorrosionPlugin.declareRegistryImage(reg, "images/cargo16.png");
        CorrosionPlugin.declareRegistryImage(reg, "icons/rustEditorIcon.png");
    }

    private static final void declareRegistryImage(ImageRegistry reg, String image) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        URL url = null;
        Bundle bundle = plugin.getBundle();
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(image), null)) != null) {
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        reg.put(image, desc);
    }

    public static boolean validateCommandVersion(String[] commandStrings, Pattern matchPattern) {
        String[] command = new String[1 + commandStrings.length];
        System.arraycopy(commandStrings, 0, command, 0, commandStrings.length);
        command[commandStrings.length] = "--version";
        return matchPattern.matcher(CorrosionPlugin.getOutputFromCommand(command)).matches();
    }

    public static boolean validateCommandVersion(String commandPath, Pattern matchPattern) {
        return matchPattern.matcher(CorrosionPlugin.getOutputFromCommand(commandPath, "--version")).matches();
    }

    public static Process getProcessForCommand(String ... commandStrings) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(commandStrings);
        builder.directory(CorrosionPlugin.getWorkingDirectoryFromPreferences());
        return builder.start();
    }

    private static File getWorkingDirectoryFromPreferences() {
        String wdString = CorrosionPlugin.getDefault().getPreferenceStore().getString("corrosion.workingDirectory");
        if (wdString == null) {
            return null;
        }
        File wdFile = new File(wdString);
        if (wdFile.exists() && wdFile.isDirectory()) {
            return wdFile;
        }
        return null;
    }

    public static String getOutputFromCommand(String ... commandStrings) {
        try {
            Process process = CorrosionPlugin.getProcessForCommand(commandStrings);
            if (process.waitFor() == 0) {
                Throwable throwable = null;
                Object var3_6 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    return in.readLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    public static void activateUnitTestCoreBundle() {
        Assert.isNotNull((Object)Platform.getBundle((String)"org.eclipse.unittest.ui"));
    }

    public static final String[] getRegisteredContentTypeIds() {
        Set<String> contentTypes = CorrosionPlugin.collectContentTypeIds();
        return contentTypes.toArray(new String[contentTypes.size()]);
    }

    private static final Set<String> collectContentTypeIds() {
        HashSet<String> allTypes = new HashSet<String>();
        allTypes.add(CONTENT_TYPE_CORROSION_RUST);
        allTypes.add(CONTENT_TYPE_CORROSION_TOML);
        allTypes.add(CONTENT_TYPE_CORROSION_MANIFEST);
        return allTypes;
    }

    public void saveCommonSourceLocations(ICargoSourceLocation[] locations) {
        CorrosionPlugin.getDefault().getPluginPreferences().setValue(PREF_SOURCE_LOCATIONS, CargoSourceUtils.getCommonSourceLocationsMemento(locations));
    }

    public ICargoSourceLocation[] getCommonSourceLocations() {
        return CargoSourceUtils.getCommonSourceLocationsFromMemento(CorrosionPlugin.getDefault().getPluginPreferences().getString(PREF_SOURCE_LOCATIONS));
    }

    private void initializeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector == null) {
            this.fCommonSourceLookupDirector = new CargoCommonSourceLookupDirector();
            boolean convertingFromLegacyFormat = false;
            String newMemento = CorrosionPlugin.getDefault().getPluginPreferences().getString(PREF_DEFAULT_SOURCE_CONTAINERS);
            if (newMemento.isEmpty()) {
                newMemento = CorrosionPlugin.getDefault().getPluginPreferences().getString(PREF_COMMON_SOURCE_CONTAINERS);
                convertingFromLegacyFormat = true;
            }
            if (newMemento.isEmpty()) {
                this.fCommonSourceLookupDirector.initializeParticipants();
                this.convertSourceLocations(this.fCommonSourceLookupDirector);
            } else {
                try {
                    this.fCommonSourceLookupDirector.initializeFromMemento(newMemento);
                }
                catch (CoreException e) {
                    CorrosionPlugin.logError(e.getStatus());
                }
            }
            if (convertingFromLegacyFormat) {
                ISourceContainer[] oldContainers = this.fCommonSourceLookupDirector.getSourceContainers();
                ISourceContainer[] containers = new ISourceContainer[oldContainers.length + 2];
                int i = 0;
                containers[i++] = new CargoAbsolutePathSourceContainer();
                containers[i++] = new CargoProjectSourceContainer(null, true);
                System.arraycopy(oldContainers, 0, containers, i, oldContainers.length);
                this.fCommonSourceLookupDirector.setSourceContainers(containers);
            }
        }
    }

    private void disposeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector != null) {
            this.fCommonSourceLookupDirector.dispose();
        }
    }

    public CargoSourceLookupDirector getCommonSourceLookupDirector() {
        return this.fCommonSourceLookupDirector;
    }

    private void convertSourceLocations(CargoCommonSourceLookupDirector director) {
        director.setSourceContainers(CargoSourceUtils.convertSourceLocations(this.getCommonSourceLocations()));
    }

    public IRetrieveFileTransfer getFileTransferService() {
        IRetrieveFileTransferFactory factory = (IRetrieveFileTransferFactory)this.getFileTransferServiceTracker().getService();
        return factory.newInstance();
    }

    private synchronized ServiceTracker<IRetrieveFileTransferFactory, IRetrieveFileTransferFactory> getFileTransferServiceTracker() {
        if (this.retrievalFactoryTracker == null) {
            this.retrievalFactoryTracker = new ServiceTracker(CorrosionPlugin.getContext(), IRetrieveFileTransferFactory.class, null);
            this.retrievalFactoryTracker.open();
            CorrosionPlugin.startBundle("org.eclipse.ecf");
            CorrosionPlugin.startBundle("org.eclipse.ecf.provider.filetransfer");
        }
        return this.retrievalFactoryTracker;
    }

    private static boolean startBundle(String bundleId) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = CorrosionPlugin.getContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equals(bundleId) && (bundle.getState() & 2) == 0) {
                try {
                    bundle.start(2);
                    bundle.start(1);
                    return true;
                }
                catch (BundleException e) {
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }
}

