/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.test.CargoTestRunnerClient;
import org.eclipse.corrosion.test.actions.OpenEditorAtLineAction;
import org.eclipse.corrosion.test.actions.OpenTestAction;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.unittest.launcher.ITestRunnerClient;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.model.ITestSuiteElement;
import org.eclipse.unittest.ui.ITestViewSupport;

public class CargoTestViewSupport
implements ITestViewSupport {
    public static final String FRAME_PREFIX = " at ";
    private static final String EXACT_FLAG = "--exact";
    private static final String TEST_FLAG = "--test";

    public ITestRunnerClient newTestRunnerClient(ITestRunSession session) {
        return new CargoTestRunnerClient(session);
    }

    public IAction getOpenTestAction(Shell shell, ITestCaseElement testCase) {
        return new OpenTestAction(shell, testCase);
    }

    public IAction getOpenTestAction(Shell shell, ITestSuiteElement testSuite) {
        return new OpenTestAction(shell, testSuite);
    }

    public IAction createOpenEditorAction(Shell shell, ITestElement failure, String traceLine) {
        block3: {
            int indexOfFramePrefix = traceLine.indexOf(FRAME_PREFIX);
            if (indexOfFramePrefix != -1) break block3;
            return null;
        }
        try {
            int columNumberIndex = traceLine.lastIndexOf(58);
            int lineNumberIndex = traceLine.lastIndexOf(58, columNumberIndex - 1);
            String testName = traceLine.substring(traceLine.indexOf(FRAME_PREFIX) + FRAME_PREFIX.length(), lineNumberIndex).trim();
            String lineNumber = traceLine.substring(lineNumberIndex + 1, columNumberIndex).trim();
            int line = Integer.parseInt(lineNumber);
            return new OpenEditorAtLineAction(shell, testName, failure.getTestRunSession(), line);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            CorrosionPlugin.logError(e);
            return null;
        }
    }

    public Runnable createShowStackTraceInConsoleViewActionDelegate(ITestElement failedTest) {
        return null;
    }

    public String getDisplayName() {
        return "Cargo";
    }

    public Collection<StringMatcher> getTraceExclusionFilterPatterns() {
        return Collections.emptySet();
    }

    public ILaunchConfiguration getRerunLaunchConfiguration(List<ITestElement> testElements) {
        if (testElements.isEmpty()) {
            return null;
        }
        ILaunchConfiguration origin = testElements.get(0).getTestRunSession().getLaunch().getLaunchConfiguration();
        try {
            ILaunchConfigurationWorkingCopy res = origin.copy(String.valueOf(origin.getName()) + "\ud83d\udd03");
            ArrayList list = (ArrayList)testElements.stream().map(CargoTestViewSupport::packTestPaths).collect(Collectors.toList());
            String testName = "";
            StringBuilder attributes = new StringBuilder();
            if (list.size() == 1) {
                testName = (String)list.get(0);
                attributes.append(EXACT_FLAG);
                System.out.println("ReRun ONE test: name: [" + testName + "], options: [" + attributes.toString() + "]");
            } else if (list.size() > 1) {
                attributes.append(TEST_FLAG);
                for (String v : list) {
                    attributes.append(' ').append(v.trim());
                }
                System.out.println("ReRun MULTIPLE (" + list.size() + ") tests: name: [" + testName + "], options: [" + attributes.toString() + "]");
            } else {
                System.out.println("ReRun ALL tests: name: [" + testName + "], options: [" + attributes.toString() + "]");
            }
            res.setAttribute("TEST_NAME", testName);
            res.setAttribute("ARGUMENTS", attributes.toString());
            return res;
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
            return null;
        }
    }

    private static String packTestPaths(ITestElement testElement) {
        if (testElement instanceof ITestCaseElement) {
            return testElement.getTestName();
        }
        if (testElement instanceof ITestSuiteElement && testElement.getParent() != null && !(testElement.getParent() instanceof ITestRunSession) && !(testElement.getParent().getParent() instanceof ITestRunSession)) {
            return testElement.getTestName();
        }
        return "";
    }
}

