/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.text.AbstractTextDiagramProvider;
import org.eclipse.core.runtime.IPath;

public class TextEditorDiagramTextProvider
extends AbstractTextDiagramProvider {
    private final String diagramPrefix;
    private String diagramPrefixRegex;
    private final String diagramSuffix;
    private String diagramSuffixRegex;
    private final Collection<String> fileExtensions = new ArrayList<String>();

    public TextEditorDiagramTextProvider(String diagramPrefix, String diagramSuffix, String ... fileExtensions) {
        this.diagramPrefix = diagramPrefix;
        this.diagramSuffix = diagramSuffix;
        this.setFileExtensions(fileExtensions);
    }

    protected void setFileExtensions(String ... fileExtensions) {
        this.fileExtensions.addAll(Arrays.asList(fileExtensions));
    }

    public void setDiagramPrefixRegex(String diagramPrefixRegex) {
        this.diagramPrefixRegex = diagramPrefixRegex;
    }

    public void setDiagramSuffixRegex(String diagramSuffixRegex) {
        this.diagramSuffixRegex = diagramSuffixRegex;
    }

    @Override
    protected String getStartPlantUml() {
        return this.diagramPrefix;
    }

    @Override
    protected String getStartPlantUmlRegex() {
        return this.diagramPrefixRegex;
    }

    @Override
    protected String getEndPlantUml() {
        return this.diagramSuffix;
    }

    @Override
    protected String getEndPlantUmlRegex() {
        return this.diagramSuffixRegex;
    }

    public boolean supportsPath(IPath path) {
        return this.fileExtensions == null || this.fileExtensions.isEmpty() || this.fileExtensions.contains(path.getFileExtension());
    }
}

