/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.monitoring.lib.CCoverageInfo;
import org.eclipse.comma.monitoring.lib.CTraceResults;

public class CTaskResults {
    @Expose
    private String taskName;
    @Expose
    private String taskKind;
    @Expose
    private String modelName;
    @Expose
    private List<CTraceResults> traceResults;
    @Expose
    private List<CCoverageInfo> coverageInfo = new ArrayList<CCoverageInfo>();

    public CTaskResults(String taskName, String taskKind, String modelName) {
        this.taskName = taskName;
        this.taskKind = taskKind;
        this.modelName = modelName;
        this.traceResults = new ArrayList<CTraceResults>();
    }

    public void addTraceResults(CTraceResults traceResult) {
        this.traceResults.add(traceResult);
        for (CCoverageInfo newInfo : traceResult.getCoverageInfo()) {
            boolean interfaceFound = false;
            for (CCoverageInfo info : this.coverageInfo) {
                if (!info.getInterfaceName().equals(newInfo.getInterfaceName())) continue;
                info.union(newInfo);
                interfaceFound = true;
                break;
            }
            if (interfaceFound) continue;
            CCoverageInfo clonedNewInfo = new CCoverageInfo();
            clonedNewInfo.union(newInfo);
            clonedNewInfo.setInterfaceName(newInfo.getInterfaceName());
            this.coverageInfo.add(clonedNewInfo);
        }
    }
}

