/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.parser.AboutParser;
import org.eclipse.help.internal.webapp.servlet.AboutServlet;
import org.eclipse.help.internal.webapp.servlet.PreferenceWriter;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class AboutService
extends AboutServlet {
    private static final long serialVersionUID = 1L;
    private long service;

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean boolIsJSON;
        boolean boolIsHTML;
        req.setCharacterEncoding("UTF-8");
        String returnType = req.getParameter("returnType");
        boolean bl = boolIsHTML = returnType != null && returnType.equalsIgnoreCase("html");
        if (boolIsHTML) {
            super.doGet(req, resp);
            return;
        }
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.setContentType("application/xml; charset=UTF-8");
        this.locale = UrlUtil.getLocaleObj(req, resp);
        String response = this.processRequest(req, resp);
        boolean bl2 = boolIsJSON = returnType != null && returnType.equalsIgnoreCase("json");
        if (boolIsJSON) {
            resp.setContentType("text/plain");
            response = this.getJSONResponse(response);
        }
        resp.getWriter().write(response);
    }

    protected String getJSONResponse(String response) throws IOException {
        AboutParser aboutParser = new AboutParser(this.service);
        if (response != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayInputStream is = new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8));){
                    aboutParser.parse(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return aboutParser.toJSON();
    }

    private String processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        String showParam = req.getParameter("show");
        if ("agent".equalsIgnoreCase(showParam)) {
            this.getAgent(buf, req, resp);
        } else if ("preferences".equalsIgnoreCase(showParam)) {
            this.getPreferences(buf, resp);
        } else {
            this.getAboutPlugins(buf, req, resp);
        }
        return buf.toString();
    }

    private void getAgent(StringBuilder buf, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.service = 1L;
        String title = WebappResources.getString("userAgent", this.locale);
        String agent = req.getHeader("User-Agent");
        buf.append("<userAgent\n      title=\"");
        buf.append(XMLGenerator.xmlEscape(title));
        buf.append("\">");
        buf.append(agent);
        buf.append("</userAgent>");
    }

    private void getPreferences(StringBuilder buf, HttpServletResponse resp) throws IOException {
        this.service = 2L;
        String title = WebappResources.getString("preferences", this.locale);
        buf.append("<preferences\n      title=\"");
        buf.append(XMLGenerator.xmlEscape(title));
        buf.append("\">");
        PreferenceWriter writer = new PreferenceWriter(buf, this.locale, true);
        writer.writePreferences();
        buf.append("\n</preferences>");
    }

    private void getAboutPlugins(StringBuilder buf, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String[] headerColumns;
        Bundle[] bundles;
        this.service = 3L;
        String sortParam = req.getParameter("sortColumn");
        int sortColumn = 3;
        if (sortParam != null) {
            try {
                sortColumn = Integer.parseInt(sortParam);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String title = WebappResources.getString("aboutPlugins", this.locale);
        buf.append("<aboutPlugins\n      title=\"");
        buf.append(XMLGenerator.xmlEscape(title));
        buf.append("\"");
        ArrayList<AboutServlet.PluginDetails> plugins = new ArrayList<AboutServlet.PluginDetails>();
        Bundle[] bundleArray = bundles = FrameworkUtil.getBundle(AboutServlet.class).getBundleContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            plugins.add(this.pluginDetails(bundle));
            ++n2;
        }
        AboutServlet.PluginComparator pluginComparator = new AboutServlet.PluginComparator(sortColumn);
        plugins.sort(pluginComparator);
        String[] stringArray = headerColumns = new String[]{"provider", "pluginName", "version", "pluginId"};
        int n3 = headerColumns.length;
        int n4 = 0;
        while (n4 < n3) {
            String headerColumn = stringArray[n4];
            buf.append("\n          ");
            buf.append(headerColumn);
            buf.append("=\"");
            buf.append(XMLGenerator.xmlEscape(WebappResources.getString(headerColumn, this.locale)));
            buf.append("\"");
            ++n4;
        }
        buf.append(">");
        for (AboutServlet.PluginDetails details : plugins) {
            buf.append("\n        <plugin");
            int i = 0;
            while (i < headerColumns.length) {
                buf.append("\n          ");
                buf.append(headerColumns[i]);
                buf.append("=\"");
                buf.append(XMLGenerator.xmlEscape(details.columns[i]));
                buf.append("\"");
                ++i;
            }
            buf.append(">\n        </plugin>");
        }
        buf.append("\n</aboutPlugins>");
    }
}

