/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.StringConcatToTextBlockFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;

public class StringConcatToTextBlockCleanUpCore
extends AbstractCleanUpCore {
    public StringConcatToTextBlockCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public StringConcatToTextBlockCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        return new CleanUpRequirementsCore(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.stringconcat_to_textblock");
    }

    @Override
    public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.stringconcat_to_textblock")) {
            return null;
        }
        return StringConcatToTextBlockFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.stringconcat_to_textblock")) {
            return new String[]{MultiFixMessages.StringConcatToTextBlockCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        if (this.isEnabled("cleanup.stringconcat_to_textblock")) {
            bld.append("String buf = \"\"\"\n");
            bld.append("    public class A {\n");
            bld.append("        public void foo() {\n");
            bld.append("        }\n");
            bld.append("    }\n");
            bld.append("    \"\"\";\n");
        } else {
            bld.append("String buf = \"\" +\n");
            bld.append("    \"public class A {\" +\n");
            bld.append("    \"    public void foo() {\" +\n");
            bld.append("    \"    }\" + \n");
            bld.append("    \"}\";\n");
        }
        return bld.toString();
    }
}

