/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportLabelProvider;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Version;

public abstract class BaseImportWizardSecondPage
extends WizardPage
implements IModelProviderListener {
    protected static final String SETTINGS_ADD_FRAGMENTS = "addFragments";
    protected static final String SETTINGS_AUTOBUILD = "autobuild";
    protected PluginImportWizardFirstPage fPage1;
    protected IPluginModelBase[] fModels = new IPluginModelBase[0];
    private Object fImportSource;
    private int fImportType;
    protected Button fAddFragmentsButton;
    private Button fAutoBuildButton;
    protected TableViewer fImportListViewer;
    private boolean fRefreshNeeded = true;

    public BaseImportWizardSecondPage(String pageName, PluginImportWizardFirstPage page) {
        super(pageName);
        this.fPage1 = page;
        PDECore.getDefault().getModelManager().getExternalModelManager().addModelProviderListener((IModelProviderListener)this);
    }

    protected Composite createImportList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.ImportWizard_DetailedPage_importList);
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.fImportListViewer = new TableViewer(table);
        this.fImportListViewer.setLabelProvider((IBaseLabelProvider)new PluginImportLabelProvider());
        this.fImportListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fImportListViewer.setInput((Object)PDECore.getDefault().getModelManager().getExternalModelManager());
        this.fImportListViewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        return container;
    }

    protected void createComputationsOption(Composite parent) {
        this.fAddFragmentsButton = SWTFactory.createCheckButton(parent, PDEUIMessages.ImportWizard_SecondPage_addFragments, null, true, 1);
        if (this.getDialogSettings().get(SETTINGS_ADD_FRAGMENTS) != null) {
            this.fAddFragmentsButton.setSelection(this.getDialogSettings().getBoolean(SETTINGS_ADD_FRAGMENTS));
        } else {
            this.fAddFragmentsButton.setSelection(true);
        }
        if (!PDEPlugin.getWorkspace().isAutoBuilding()) {
            this.fAutoBuildButton = SWTFactory.createCheckButton(parent, PDEUIMessages.BaseImportWizardSecondPage_autobuild, null, this.getDialogSettings().getBoolean(SETTINGS_AUTOBUILD), 1);
        }
    }

    public void dispose() {
        PDECore.getDefault().getModelManager().getExternalModelManager().removeModelProviderListener((IModelProviderListener)this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.isRefreshNeeded()) {
            this.fModels = this.fPage1.getModels();
            this.refreshPage();
        }
    }

    protected abstract void refreshPage();

    protected boolean isRefreshNeeded() {
        if (this.fRefreshNeeded) {
            this.fRefreshNeeded = false;
            this.fImportSource = this.fPage1.getImportSource();
            this.fImportType = this.fPage1.getImportType();
            return true;
        }
        Object currSource = this.fPage1.getImportSource();
        if (this.fImportSource == null || !this.fImportSource.equals(currSource)) {
            this.fImportSource = this.fPage1.getImportSource();
            return true;
        }
        int currType = this.fPage1.getImportType();
        if (currType != this.fImportType) {
            if (currType == 4 || this.fImportType == 4) {
                this.fImportType = currType;
                return true;
            }
            this.fImportType = currType;
        }
        return this.fPage1.isRefreshNeeded();
    }

    private IPluginModelBase findModel(String id, String version) {
        IPluginModelBase bestMatch = null;
        IPluginModelBase[] iPluginModelBaseArray = this.fModels;
        int n = this.fModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            String modelId = model.getPluginBase().getId();
            if (modelId != null && modelId.equals(id)) {
                String modelVersion = model.getPluginBase().getVersion();
                if (modelVersion != null && modelVersion.equals(version)) {
                    return model;
                }
                if (bestMatch == null || bestMatch.getPluginBase().getVersion() == null || version == null) {
                    bestMatch = model;
                } else {
                    Version currentVersion;
                    Version bestVersion = Version.parseVersion((String)bestMatch.getPluginBase().getVersion());
                    if (bestVersion.compareTo(currentVersion = Version.parseVersion((String)version)) < 0) {
                        bestMatch = model;
                    }
                }
            }
            ++n2;
        }
        return bestMatch;
    }

    private IFragmentModel[] findFragments(IPlugin plugin) {
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = this.fModels;
        int n = this.fModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model instanceof IFragmentModel) {
                IFragment fragment = ((IFragmentModel)model).getFragment();
                if (plugin.getId().equalsIgnoreCase(fragment.getPluginId())) {
                    result.add(model);
                }
            }
            ++n2;
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }

    protected void addPluginAndDependencies(IPluginModelBase model, ArrayList<IPluginModelBase> selected, boolean addFragments) {
        boolean containsVariable = false;
        if (!selected.contains(model)) {
            selected.add(model);
            boolean hasextensibleAPI = ClasspathUtilCore.hasExtensibleAPI((IPluginModelBase)model);
            if (!addFragments && !hasextensibleAPI && model instanceof IPluginModel) {
                IPluginLibrary[] libraries;
                IPluginLibrary[] iPluginLibraryArray = libraries = model.getPluginBase().getLibraries();
                int n = libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginLibrary library = iPluginLibraryArray[n2];
                    if (ClasspathUtilCore.containsVariables((String)library.getName())) {
                        containsVariable = true;
                        break;
                    }
                    ++n2;
                }
            }
            this.addDependencies(model, selected, addFragments || containsVariable || hasextensibleAPI);
        }
    }

    protected void addUnresolvedImportPackagesModels(IPluginModelBase model, ArrayList<IPluginModelBase> result, boolean addFragments) {
        ISharedPluginModel sharedModel = model.getPluginBase().getModel();
        if (sharedModel instanceof BundlePluginModel) {
            ImportPackageSpecification[] importPackages;
            BundlePluginModel bundleModel = (BundlePluginModel)sharedModel;
            ImportPackageSpecification[] importPackageSpecificationArray = importPackages = bundleModel.getBundleDescription().getImportPackages();
            int n = importPackages.length;
            int n2 = 0;
            while (n2 < n) {
                ImportPackageSpecification importPackageSpecification = importPackageSpecificationArray[n2];
                IPluginModelBase found = this.findModel(importPackageSpecification.getName(), null);
                IPluginModelBase[] iPluginModelBaseArray = this.fModels;
                int n3 = this.fModels.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription[] exportPackages;
                    IPluginModelBase mod = iPluginModelBaseArray[n4];
                    ExportPackageDescription[] exportPackageDescriptionArray = exportPackages = mod.getBundleDescription().getExportPackages();
                    int n5 = exportPackages.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ExportPackageDescription exp = exportPackageDescriptionArray[n6];
                        if (exp.getName().equals(importPackageSpecification.getName())) {
                            found = mod;
                            break;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                if (found != null) {
                    this.addPluginAndDependencies(found, result, addFragments);
                }
                ++n2;
            }
        }
    }

    protected void addDependencies(IPluginModelBase model, ArrayList<IPluginModelBase> selected, boolean addFragments) {
        int n;
        IPluginImport[] required = model.getPluginBase().getImports();
        if (required.length > 0) {
            IPluginImport[] iPluginImportArray = required;
            n = required.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginImport pluginImport = iPluginImportArray[n2];
                IPluginModelBase found = this.findModel(pluginImport.getId(), pluginImport.getVersion());
                if (found != null) {
                    this.addPluginAndDependencies(found, selected, addFragments);
                }
                ++n2;
            }
        }
        if (addFragments) {
            if (model instanceof IPluginModel) {
                IFragmentModel[] fragments;
                IFragmentModel[] iFragmentModelArray = fragments = this.findFragments(((IPluginModel)model).getPlugin());
                int n3 = fragments.length;
                n = 0;
                while (n < n3) {
                    IFragmentModel fragment = iFragmentModelArray[n];
                    this.addPluginAndDependencies((IPluginModelBase)fragment, selected, addFragments);
                    ++n;
                }
            } else {
                IFragment fragment = ((IFragmentModel)model).getFragment();
                IPluginModelBase found = this.findModel(fragment.getPluginId(), fragment.getVersion());
                if (found != null) {
                    this.addPluginAndDependencies(found, selected, addFragments);
                }
            }
        }
    }

    public IPluginModelBase[] getModelsToImport() {
        TableItem[] items = this.fImportListViewer.getTable().getItems();
        ArrayList<Object> result = new ArrayList<Object>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            result.add(item.getData());
            ++n2;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SETTINGS_ADD_FRAGMENTS, this.fAddFragmentsButton.getSelection());
        if (this.fAutoBuildButton != null) {
            settings.put(SETTINGS_AUTOBUILD, this.fAutoBuildButton.getSelection());
        }
    }

    public void modelsChanged(IModelProviderEvent event) {
        this.fRefreshNeeded = true;
    }

    public boolean forceAutoBuild() {
        return this.fAutoBuildButton != null && this.getDialogSettings().getBoolean(SETTINGS_AUTOBUILD);
    }

    protected void checkRepositoryAvailability() {
        PluginImportWizardFirstPage page = (PluginImportWizardFirstPage)this.getPreviousPage();
        if (page.getImportType() == 4 && this.getMessageType() != 3 && this.getMessageType() != 2) {
            IPluginModelBase[] selected = this.getModelsToImport();
            Set<Object> available = page.repositoryModels;
            int i = 0;
            while (i < selected.length) {
                if (!available.contains(selected[i])) {
                    this.setMessage(PDEUIMessages.BaseImportWizardSecondPage_0, 2);
                    return;
                }
                ++i;
            }
        }
    }

    static class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object element) {
            return new Object[0];
        }
    }
}

