/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintState;
import org.eclipse.comma.monitoring.lib.CPathDescription;

public class CFunctionalConstraintContext
implements Serializable {
    private Map<String, Map<String, CPathDescription>> portsStates = new HashMap<String, Map<String, CPathDescription>>();
    private Map<String, Set<String>> initialPortStates;
    private List<CFunctionalConstraintState> constraintExecutionStates;

    private Set<String> getPortStates(String port, String connection, boolean isContext) {
        CPathDescription pd = this.portsStates.get(port).get(connection);
        if (pd.forwardPort == null) {
            return isContext ? pd.getActiveStates() : pd.getPostEventStates();
        }
        CPathDescription forwardPd = this.portsStates.get(pd.forwardPort).get(pd.forwardConnection);
        return isContext ? forwardPd.getActiveStates() : forwardPd.getPostEventStates();
    }

    public Map<String, Map<String, CPathDescription>> getPortsStates() {
        return this.portsStates;
    }

    public void setPortsStates(Map<String, Map<String, CPathDescription>> newPortsStates) {
        this.portsStates = newPortsStates;
    }

    public void setInitialPortsStates(Map<String, Set<String>> initialValues) {
        this.initialPortStates = initialValues;
    }

    public List<CFunctionalConstraintState> getConstraintExecutionStates() {
        return this.constraintExecutionStates;
    }

    public void setConstraintExecutionStates(List<CFunctionalConstraintState> newStates) {
        this.constraintExecutionStates = newStates;
    }

    public boolean portInState(String port, String state, String contextPort, String contextConnection) {
        if (this.portsStates.containsKey(port)) {
            return this.allAtPortInState(port, new HashSet<String>(Arrays.asList(state)), contextPort, contextConnection);
        }
        return this.initialPortStates.get(port).contains(state);
    }

    private boolean isContext(String port, String connection, String contextPort, String contextConnection) {
        if (contextPort == null) {
            return false;
        }
        if (port.equals(contextPort) && connection.equals(contextConnection)) {
            return true;
        }
        CPathDescription pd = this.portsStates.get(port).get(connection);
        if (pd.forwardPort != null && pd.forwardPort.equals(contextPort) && pd.forwardConnection.equals(contextConnection)) {
            return true;
        }
        pd = this.portsStates.get(contextPort).get(contextConnection);
        return pd.forwardPort != null && pd.forwardPort.equals(port) && pd.forwardConnection.equals(connection);
    }

    public boolean allAtPortInState(String port, Set<String> states, String contextPort, String contextConnection) {
        if (!this.portsStates.containsKey(port)) {
            return true;
        }
        for (String connection : this.portsStates.get(port).keySet()) {
            Set<String> actualStates = this.getPortStates(port, connection, this.isContext(port, connection, contextPort, contextConnection));
            HashSet<String> intersection = new HashSet<String>(actualStates);
            intersection.retainAll(states);
            if (!intersection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean someAtPortInState(String port, Set<String> states, String contextPort, String contextConnection, int lower, int upper) {
        int count = 0;
        Map<String, CPathDescription> connectionsAtPort = this.portsStates.get(port);
        if (connectionsAtPort != null) {
            for (String connection : connectionsAtPort.keySet()) {
                Set<String> actualStates = this.getPortStates(port, connection, this.isContext(port, connection, contextPort, contextConnection));
                HashSet<String> intersection = new HashSet<String>(actualStates);
                intersection.retainAll(states);
                if (intersection.isEmpty()) continue;
                ++count;
            }
        }
        return upper != -1 ? lower <= count && count <= upper : lower <= count;
    }

    public boolean connectionAtPortInState(String connection, String port, Set<String> states, String contextPort, String contextConnection) {
        Map<String, CPathDescription> connectionsAtPort = this.portsStates.get(port);
        if (connectionsAtPort == null) {
            return false;
        }
        CPathDescription connectionInfo = connectionsAtPort.get(connection);
        if (connectionInfo == null) {
            return false;
        }
        Set<String> actualStates = this.getPortStates(port, connection, this.isContext(port, connection, contextPort, contextConnection));
        HashSet<String> intersection = new HashSet<String>(actualStates);
        intersection.retainAll(states);
        if (intersection.isEmpty()) {
            return false;
        }
        return !intersection.isEmpty();
    }
}

