/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.DefaultUniqueNameContext;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.validation.INamesAreUniqueValidationHelper;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class NamesAreUniqueValidator
extends AbstractDeclarativeValidator {
    @Deprecated
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry = IResourceServiceProvider.Registry.INSTANCE;
    @Inject
    private INamesAreUniqueValidationHelper helper;
    @Inject
    private INamesAreUniqueValidationHelper.ContextProvider contextProvider = new DefaultUniqueNameContext.ExportedFromResource();

    @Override
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkUniqueNamesInResourceOf(EObject eObject) {
        if (eObject.eContainer() != null) {
            return;
        }
        Map<Object, Object> context = this.getContext();
        Resource resource = eObject.eResource();
        if (resource == null) {
            return;
        }
        CancelIndicator cancelIndicator = null;
        if (context != null) {
            if (context.containsKey(resource)) {
                return;
            }
            context.put(resource, this);
            cancelIndicator = (CancelIndicator)context.get(CancelableDiagnostician.CANCEL_INDICATOR);
        }
        this.doCheckUniqueNames(resource, cancelIndicator);
    }

    public void doCheckUniqueNames(Resource resource, CancelIndicator cancelIndicator) {
        INamesAreUniqueValidationHelper.Context validationContext = this.getValidationContext(resource, cancelIndicator);
        if (validationContext != null) {
            this.helper.checkUniqueNames(validationContext, (ValidationMessageAcceptor)this);
        }
    }

    protected INamesAreUniqueValidationHelper.Context getValidationContext(Resource resource, CancelIndicator cancelIndicator) {
        return this.contextProvider.tryGetContext(resource, cancelIndicator);
    }

    public void setHelper(INamesAreUniqueValidationHelper helper) {
        this.helper = helper;
    }

    public INamesAreUniqueValidationHelper getHelper() {
        return this.helper;
    }

    @Deprecated
    public void setResourceServiceProviderRegistry(IResourceServiceProvider.Registry resourceDescriptionManagerRegistry) {
        this.resourceServiceProviderRegistry = resourceDescriptionManagerRegistry;
        if (this.contextProvider instanceof DefaultUniqueNameContext.BaseContextProvider) {
            ((DefaultUniqueNameContext.BaseContextProvider)this.contextProvider).setResourceServiceProviderRegistry(resourceDescriptionManagerRegistry);
        }
    }

    @Deprecated
    public IResourceServiceProvider.Registry getResourceServiceProviderRegistry() {
        return this.resourceServiceProviderRegistry;
    }

    public INamesAreUniqueValidationHelper.ContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public void setContextProvider(INamesAreUniqueValidationHelper.ContextProvider contextProvider) {
        this.contextProvider = (INamesAreUniqueValidationHelper.ContextProvider)Preconditions.checkNotNull((Object)contextProvider);
    }
}

