/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.editor.utils.ProjectHelper;
import org.eclipse.ant.internal.ui.model.AntImportNode;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.xml.sax.Attributes;

public class AntIncludeNode
extends AntImportNode {
    public AntIncludeNode(Task task, Attributes attributes) {
        super(task, attributes);
    }

    @Override
    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antImport");
    }

    @Override
    public boolean configure(boolean validateFully) {
        if (this.fConfigured) {
            return false;
        }
        try {
            this.getTask().maybeConfigure();
            AntTaskNode importedFromNode = (AntTaskNode)this.getImportNode();
            if (importedFromNode != null) {
                String currentPrefix = this.getIncludePrefix(importedFromNode);
                org.apache.tools.ant.ProjectHelper.setCurrentTargetPrefix((String)currentPrefix);
            } else {
                org.apache.tools.ant.ProjectHelper.setCurrentTargetPrefix(null);
            }
            this.getTask().execute();
            this.fConfigured = true;
            return true;
        }
        catch (BuildException be) {
            this.handleBuildException(be, "problem_imports");
        }
        catch (AntSecurityException antSecurityException) {
            this.handleBuildException(new BuildException(AntModelMessages.AntImportNode_0), "problem_security");
        }
        return false;
    }

    private String getIncludePrefix(AntTaskNode startNode) {
        AntTaskNode actualNode = startNode;
        StringBuilder builder = new StringBuilder();
        while (actualNode != null) {
            String actualPrefixSeparator = org.apache.tools.ant.ProjectHelper.getCurrentPrefixSeparator();
            String actualPrefix = this.getIncludePrefixSingleNode(actualNode);
            if (actualPrefix != null) {
                builder.insert(0, String.valueOf(actualPrefix) + actualPrefixSeparator);
            }
            actualNode = (AntTaskNode)actualNode.getImportNode();
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private String getIncludePrefixSingleNode(AntTaskNode importedFromNode) {
        String includePrefix;
        Object asPropValue = importedFromNode.getTask().getRuntimeConfigurableWrapper().getAttributeMap().get("as");
        String string = includePrefix = asPropValue != null ? asPropValue.toString() : null;
        if (includePrefix == null) {
            includePrefix = this.extractProjectNameSingleNode(importedFromNode);
        }
        return includePrefix;
    }

    private String extractProjectNameSingleNode(AntTaskNode importedFromNode) {
        IFile projectSpecificBuildFile = this.handleCorrectBuildFile(importedFromNode);
        if (projectSpecificBuildFile != null) {
            return ProjectHelper.getProjectNameOfBuildFile(projectSpecificBuildFile);
        }
        return ProjectHelper.getProjectNameOfBuildFile(this.getFilePath());
    }

    private IFile handleCorrectBuildFile(AntTaskNode importedFromNode) {
        Boolean isExternal = null;
        try {
            isExternal = importedFromNode.isExternal();
            importedFromNode.setExternal(false);
            IFile iFile = importedFromNode.getIFile();
            return iFile;
        }
        finally {
            importedFromNode.setExternal(isExternal);
        }
    }
}

