/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.model.TypeStructureBuilder;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public abstract class AbstractApiTypeRoot
extends ApiElement
implements IApiTypeRoot {
    private IApiType fType;

    protected AbstractApiTypeRoot(IApiElement parent, String name) {
        super(parent, 7, name);
    }

    public abstract byte[] getContents() throws CoreException;

    @Override
    public IApiType getStructure() throws CoreException {
        if (this.fType != null) {
            return this.fType;
        }
        ApiModelCache cache = ApiModelCache.getCache();
        IApiComponent comp = this.getApiComponent();
        IApiType type = null;
        if (comp != null) {
            IApiBaseline baseline = comp.getBaseline();
            type = (IApiType)cache.getElementInfo(baseline.getName(), comp.getSymbolicName(), this.getTypeName(), 2);
        }
        if (type == null) {
            type = TypeStructureBuilder.buildTypeStructure(this.getContents(), this.getApiComponent(), this);
            if (type == null) {
                return null;
            }
            Set<Object> apiComponentMultiple = Collections.emptySet();
            if (comp != null) {
                IApiBaseline baseline = comp.getBaseline();
                apiComponentMultiple = baseline.getAllApiComponents(comp.getSymbolicName());
            }
            if (apiComponentMultiple.isEmpty()) {
                cache.cacheElementInfo(type);
            }
        }
        this.fType = type;
        return this.fType;
    }

    @Override
    public IApiComponent getApiComponent() {
        return (IApiComponent)this.getAncestor(1);
    }
}

