/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager {
    private static ColorManager fgColorManager;
    protected Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);

    private ColorManager() {
    }

    public static ColorManager getDefault() {
        if (fgColorManager == null) {
            fgColorManager = new ColorManager();
        }
        return fgColorManager;
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        for (Color color : this.fColorTable.values()) {
            color.dispose();
        }
    }
}

