/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.traces.events.validation;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.component.component.ComponentModel;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.InterfaceSignatureDefinition;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.traces.events.traceEvents.Command;
import org.eclipse.comma.traces.events.traceEvents.Component;
import org.eclipse.comma.traces.events.traceEvents.Event;
import org.eclipse.comma.traces.events.traceEvents.Import;
import org.eclipse.comma.traces.events.traceEvents.Notification;
import org.eclipse.comma.traces.events.traceEvents.Reply;
import org.eclipse.comma.traces.events.traceEvents.Signal;
import org.eclipse.comma.traces.events.traceEvents.TraceEvents;
import org.eclipse.comma.traces.events.traceEvents.TraceEventsPackage;
import org.eclipse.comma.traces.events.validation.AbstractTraceEventsValidator;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class TraceEventsValidator
extends AbstractTraceEventsValidator {
    @Inject
    protected IScopeProvider scopeProvider;

    @Check
    public void checkImportForValidity(Import imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", imp, (EStructuralFeature)TraceEventsPackage.eINSTANCE.getImport_ImportURI());
        } else {
            Resource r = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            EObject head = (EObject)IteratorExtensions.head((Iterator)r.getAllContents());
            if (!(head instanceof InterfaceSignatureDefinition) && !(head instanceof ComponentModel)) {
                this.error("The imported resource is not an interface signature nor a component definition", imp, (EStructuralFeature)TraceEventsPackage.eINSTANCE.getImport_ImportURI());
            }
        }
    }

    @Check
    public void checkUniqueComponentIds(TraceEvents traces) {
        HashMultimap multiMap = HashMultimap.create();
        EList<Component> _components = traces.getComponents();
        for (Component ci : _components) {
            multiMap.put((Object)ci.getComponentId(), (Object)ci);
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (Component d : duplicates) {
                this.error("Duplicate component instance name", d, (EStructuralFeature)TraceEventsPackage.Literals.COMPONENT__COMPONENT_ID);
            }
        }
    }

    @Check
    public void checkNumberOfParameters(Event e) {
        boolean _notEquals;
        if (e == null) {
            return;
        }
        int expectedNrParams = 0;
        if (e instanceof Command) {
            Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter p) {
                    DIRECTION _direction = p.getDirection();
                    return !Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
                }
            };
            expectedNrParams = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)((Command)e).getCommand().getParameters(), (Functions.Function1)_function));
        } else if (e instanceof Signal || e instanceof Notification) {
            expectedNrParams = e.getCommand().getParameters().size();
        } else if (e instanceof Reply) {
            boolean _not_1;
            boolean _not;
            Functions.Function1<Parameter, Boolean> _function_1 = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter p) {
                    DIRECTION _direction = p.getDirection();
                    return !Objects.equal((Object)_direction, (Object)DIRECTION.IN);
                }
            };
            expectedNrParams = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)((Reply)e).getCommand().getParameters(), (Functions.Function1)_function_1));
            InterfaceEvent _command = ((Reply)e).getCommand();
            boolean bl = _not = !(_command instanceof org.eclipse.comma.signature.interfaceSignature.Command);
            if (_not) {
                return;
            }
            InterfaceEvent _command_1 = ((Reply)e).getCommand();
            Type retType = ((org.eclipse.comma.signature.interfaceSignature.Command)_command_1).getType();
            boolean _isVoid = TypeUtilities.isVoid((Type)retType);
            boolean bl2 = _not_1 = !_isVoid;
            if (_not_1) {
                ++expectedNrParams;
            }
        }
        int _size = e.getParameters().size();
        boolean bl = _notEquals = expectedNrParams != _size;
        if (_notEquals) {
            this.error("Wrong number of parameters. Expected " + Integer.valueOf(expectedNrParams) + " parameters.", (EStructuralFeature)TraceEventsPackage.Literals.EVENT__COMMAND);
        }
    }

    @Check
    public void checkCorrectUseOfComponents(TraceEvents trace) {
        boolean _not;
        boolean _isEmpty = trace.getComponents().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Set componentTypes = IterableExtensions.toSet((Iterable)CommaUtilities.resolveProxy((EObject)trace, (Iterable)this.scopeProvider.getScope((EObject)trace, TraceEventsPackage.Literals.DUMMY__COMPONENT).getAllElements()));
            boolean unknownTypeFound = false;
            EList<Component> _components = trace.getComponents();
            for (final Component cInstance : _components) {
                boolean _not_1;
                Functions.Function1<org.eclipse.comma.behavior.component.component.Component, Boolean> _function = new Functions.Function1<org.eclipse.comma.behavior.component.component.Component, Boolean>(){

                    public Boolean apply(org.eclipse.comma.behavior.component.component.Component it) {
                        return CommaUtilities.getFullyQualifiedNameAsString((NamedElement)it).equals(cInstance.getComponentType());
                    }
                };
                boolean _exists = IterableExtensions.exists((Iterable)componentTypes, (Functions.Function1)_function);
                boolean bl2 = _not_1 = !_exists;
                if (!_not_1) continue;
                unknownTypeFound = true;
                this.error("Unknown component type", cInstance, (EStructuralFeature)TraceEventsPackage.Literals.COMPONENT__COMPONENT_TYPE);
            }
            if (unknownTypeFound) {
                return;
            }
            EList<Event> _events = trace.getEvents();
            for (Event ev : _events) {
                this.checkEvent(ev, componentTypes);
            }
        }
    }

    public void checkEvent(final Event ev, Set<org.eclipse.comma.behavior.component.component.Component> componentTypes) {
        EObject _eContainer = ev.eContainer();
        TraceEvents root = (TraceEvents)_eContainer;
        boolean targetPort = true;
        EAttribute attrToHighlight = null;
        Functions.Function1<Component, Boolean> _function = new Functions.Function1<Component, Boolean>(){

            public Boolean apply(Component it) {
                return it.getComponentId().equals(ev.getSource());
            }
        };
        Component cInstance = (Component)IterableExtensions.findFirst(root.getComponents(), (Functions.Function1)_function);
        if (cInstance != null) {
            attrToHighlight = TraceEventsPackage.Literals.EVENT__SOURCE_PORT;
            targetPort = false;
        } else {
            Functions.Function1<Component, Boolean> _function_1 = new Functions.Function1<Component, Boolean>(){

                public Boolean apply(Component it) {
                    return it.getComponentId().equals(ev.getTarget());
                }
            };
            cInstance = (Component)IterableExtensions.findFirst(root.getComponents(), (Functions.Function1)_function_1);
            if (cInstance == null) {
                return;
            }
            attrToHighlight = TraceEventsPackage.Literals.EVENT__TARGET_PORT;
        }
        final String cType = cInstance.getComponentType();
        Functions.Function1<org.eclipse.comma.behavior.component.component.Component, Boolean> _function_2 = new Functions.Function1<org.eclipse.comma.behavior.component.component.Component, Boolean>(){

            public Boolean apply(org.eclipse.comma.behavior.component.component.Component it) {
                return CommaUtilities.getFullyQualifiedNameAsString((NamedElement)it).equals(cType);
            }
        };
        org.eclipse.comma.behavior.component.component.Component componentModel = (org.eclipse.comma.behavior.component.component.Component)IterableExtensions.findFirst(componentTypes, (Functions.Function1)_function_2);
        String _xifexpression = null;
        _xifexpression = targetPort ? ev.getTargetPort() : ev.getSourcePort();
        final String portName = _xifexpression;
        Functions.Function1<Port, Boolean> _function_3 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return it.getName().equals(portName);
            }
        };
        Port portDef = (Port)IterableExtensions.findFirst((Iterable)componentModel.getPorts(), (Functions.Function1)_function_3);
        if (portDef == null) {
            this.error("Port is not defined in the component model", ev, (EStructuralFeature)attrToHighlight);
            return;
        }
        boolean providedPort = portDef instanceof ProvidedPort;
        boolean _xor = targetPort ^ providedPort;
        if (_xor) {
            if (ev instanceof org.eclipse.comma.signature.interfaceSignature.Command || ev instanceof Signal) {
                this.error("Only reply or notification is allowed for this port and this direction", ev, (EStructuralFeature)attrToHighlight);
            }
        } else if (ev instanceof Reply || ev instanceof Notification) {
            this.error("Only command or signal is allowed for this port and this direction", ev, (EStructuralFeature)attrToHighlight);
        }
    }
}

