/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.evaluator;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.EConnection;
import org.eclipse.comma.evaluator.ENotification;
import org.eclipse.comma.evaluator.EOccurence;
import org.eclipse.comma.evaluator.EReply;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableType;

public class EHelper {
    public static String actionToSymbol(EAction action) {
        if (action instanceof ECommand || action instanceof EReply || action instanceof ESignal || action instanceof ENotification) {
            return String.valueOf(action.getClass().getSimpleName().charAt(1)).toUpperCase();
        }
        throw new RuntimeException("Not supported");
    }

    public static String replyReturnValueToString(EReply reply) {
        return reply.returnValue != null ? EHelper.variableToString(reply.returnValue) : "void";
    }

    public static String connectionToString(EConnection connection) {
        return String.format("%s[%s]", connection.port, connection.id);
    }

    public static String actionToString(EAction action) {
        String result = "";
        if (action.connection != null) {
            result = String.valueOf(result) + EHelper.connectionToString(action.connection) + ".";
        }
        String maskDirection = action instanceof ECommand ? "out" : (action instanceof EReply ? "in" : "");
        List arguments = action.arguments.stream().map(a -> a.direction.equals(maskDirection) ? "_" : EHelper.variableToString(a)).collect(Collectors.toList());
        result = String.valueOf(result) + String.format("%s(%s)", action.method, String.join((CharSequence)", ", arguments));
        if (action instanceof ENotification && ((ENotification)action).occurrence != null) {
            EOccurence occurence = ((ENotification)action).occurrence;
            result = String.valueOf(result) + String.format("[%s-%s]", occurence.min, occurence.max);
        }
        if (action instanceof EReply) {
            result = String.valueOf(result) + String.format(" -> %s", EHelper.replyReturnValueToString((EReply)action));
        }
        return result;
    }

    public static String variableToString(EVariable variable) {
        if (variable.type == EVariableType.ANY) {
            return "*";
        }
        if (variable.value == null) {
            return "null";
        }
        if (variable.type == EVariableType.VECTOR) {
            String value = variable.getValueVector().stream().map(v -> EHelper.variableToString(v)).collect(Collectors.joining("_"));
            return String.format("[%s]", value);
        }
        if (variable.type == EVariableType.RECORD) {
            String value = variable.getValueRecord().entrySet().stream().map(e -> String.format("%s_%s", e.getKey(), EHelper.variableToString((EVariable)e.getValue()))).collect(Collectors.joining("_"));
            return String.format("{%s}", value);
        }
        if (variable.type == EVariableType.MAP) {
            String value = variable.getValueMap().entrySet().stream().map(e -> String.format("%s_%s", EHelper.variableToString((EVariable)e.getKey()), EHelper.variableToString((EVariable)e.getValue()))).collect(Collectors.joining("_"));
            return String.format("{%s}", value);
        }
        return variable.value.toString();
    }
}

