/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class FileFilter
extends ViewerFilter {
    private List<?> fFilter;
    private Set<IResource> fFiles;
    private String fExtension;
    private Pattern fExtnPattern;
    private boolean fConsiderExtension = true;

    public FileFilter(List<?> objects, String extension) {
        this.fFilter = objects;
        this.fExtension = extension;
        this.fExtnPattern = extension.indexOf(124) > 0 ? Pattern.compile(this.fExtension, 2) : null;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.fFiles.contains(element) && !this.fFilter.contains(element);
    }

    private void init() {
        BusyIndicator.showWhile((Display)AntUIPlugin.getStandardDisplay(), () -> {
            this.fFiles = new HashSet<IResource>();
            this.traverse((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.fFiles);
        });
    }

    private boolean traverse(IContainer container, Set<IResource> set) {
        boolean added = false;
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    String ext = file.getFileExtension();
                    if (!this.fConsiderExtension || this.canAccept(ext)) {
                        set.add((IResource)file);
                        added = true;
                    }
                } else if (resource instanceof IContainer && this.traverse((IContainer)resource, set)) {
                    set.add(resource);
                    added = true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return added;
    }

    private boolean canAccept(String ext) {
        if (ext != null) {
            if (this.fExtnPattern == null) {
                return this.fExtension.equalsIgnoreCase(ext);
            }
            return this.fExtnPattern.matcher(ext).matches();
        }
        return false;
    }

    public void considerExtension(boolean considerExtension) {
        this.fConsiderExtension = considerExtension;
        this.init();
    }
}

