/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.preferences;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;
import org.eclipse.ui.internal.wizards.preferences.WizardPreferencesImportPage1;
import org.osgi.framework.FrameworkUtil;

public class PreferencesImportWizard
extends Wizard
implements IImportWizard {
    public static final String EVENT_IMPORT_END = "org/eclipse/ui/internal/wizards/preferences/import/end";
    private WizardPreferencesImportPage1 mainPage;
    private IEventBroker eventBroker;

    public PreferencesImportWizard() {
        IDialogSettings workbenchSettings = PlatformUI.getDialogSettingsProvider(FrameworkUtil.getBundle(PreferencesImportWizard.class)).getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("PreferencesImportWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("PreferencesImportWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardPreferencesImportPage1();
        this.addPage((IWizardPage)this.mainPage);
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.eventBroker = (IEventBroker)workbench.getService(IEventBroker.class);
        this.setWindowTitle(PreferencesMessages.PreferencesImportWizard_import);
        this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_WIZBAN_IMPORT_PREF_WIZ"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        boolean success = this.mainPage.finish();
        this.sendEvent(EVENT_IMPORT_END);
        this.showRestartDialog();
        return success;
    }

    private void showRestartDialog() {
        if (MessageDialog.open((int)5, (Shell)this.mainPage.getShell(), (String)PreferencesMessages.WizardPreferencesImportRestartDialog_title, (String)PreferencesMessages.WizardPreferencesImportRestartDialog_message, (int)0, (String[])new String[]{PreferencesMessages.WizardPreferencesImportRestartDialog_restart, IDialogConstants.CANCEL_LABEL}) == 0) {
            Display.getDefault().asyncExec(() -> PlatformUI.getWorkbench().restart());
        }
    }

    private void sendEvent(String topic) {
        if (this.eventBroker != null) {
            this.eventBroker.send(topic, null);
        }
    }
}

