/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.modelqualitychecks;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.InAllStatesBlock;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.modelqualitychecks.PToken;
import org.eclipse.comma.modelqualitychecks.PTransition;
import org.eclipse.comma.modelqualitychecks.PUtils;

class PPlace {
    final String name;
    final PPlaceType type;
    final State state;
    final StateMachine machine;
    private final List<PToken> tokens = new ArrayList<PToken>();

    private PPlace(String name, PPlaceType type, StateMachine machine, State state) {
        this.name = name;
        this.type = type;
        this.state = state;
        this.machine = machine;
        assert (this.type == PPlaceType.VARIABLES || this.type == PPlaceType.PARAMETERS || this.machine != null);
    }

    private static String name(String prefix, StateMachine machine, String name) {
        String machineName = "";
        if (PUtils.hasMulitpleMachine(machine)) {
            machineName = "_" + machine.getName();
        }
        return String.format("%s%s_%s", prefix, machineName, name);
    }

    static PPlace forState(StateMachine machine, State state) {
        return new PPlace(PPlace.name("S", machine, state.getName()), PPlaceType.STATE, machine, state);
    }

    static PPlace forVariables() {
        return new PPlace("V", PPlaceType.VARIABLES, null, null);
    }

    static PPlace forTransition(StateMachine machine, State state, Transition transition) {
        String key;
        String name = PPlace.name("T", machine, state.getName());
        String transitionName = "NonTriggered";
        if (transition instanceof TriggeredTransition) {
            transitionName = String.valueOf(((TriggeredTransition)transition).getTrigger().getName()) + "()";
        }
        if ((key = Integer.toString(state.getTransitions().indexOf((Object)transition))).equals("-1")) {
            InAllStatesBlock allState = machine.getInAllStates().stream().filter(s -> s.getTransitions().contains((Object)transition)).findFirst().get();
            key = String.format("ias%d.%d", machine.getInAllStates().indexOf((Object)allState), allState.getTransitions().indexOf((Object)transition));
        }
        name = String.format("%s_%s_%s", name, key, transitionName);
        return new PPlace(name, PPlaceType.TRANSITION, machine, null);
    }

    static PPlace forClause(PPlace transitionPlace, Clause clause) {
        int index = ((Transition)clause.eContainer()).getClauses().indexOf((Object)clause);
        String name = String.format("C%s_%d_0", transitionPlace.name.substring(1), index);
        return new PPlace(name, PPlaceType.CLAUSE, transitionPlace.machine, null);
    }

    static PPlace forParameters(PTransition transition) {
        String name = String.format("P_%s", transition.name);
        return new PPlace(name, PPlaceType.PARAMETERS, null, null);
    }

    static PPlace forClause(PPlace precedingPlace, String key) {
        Pattern p = Pattern.compile("^(.*)_\\d+(_join|_split|_quit)?$");
        Matcher m = p.matcher(precedingPlace.name);
        if (precedingPlace.type != PPlaceType.CLAUSE || !m.find()) {
            throw new RuntimeException("Not allowed");
        }
        String name = String.format("%s_%s", m.group(1), key);
        return new PPlace(name, PPlaceType.CLAUSE, precedingPlace.machine, null);
    }

    static PPlace forClauseNest(PPlace precedingPlace, String key) {
        assert (precedingPlace.type == PPlaceType.CLAUSE) : "Not allowed";
        String name = String.format("%s_%s", precedingPlace.name, key);
        return new PPlace(name, PPlaceType.CLAUSE, precedingPlace.machine, null);
    }

    boolean isInitial() {
        return this.type == PPlaceType.STATE && this.state.isInitial();
    }

    void addToken(PToken token) {
        this.tokens.add(token);
    }

    String toSnakes() {
        String token = "";
        if (!this.tokens.isEmpty()) {
            token = String.format(", [%s]", this.tokens.stream().map(t -> t.toSnakes()).collect(Collectors.joining(", ")));
        }
        String meta = String.format("'type': '%s'", this.type.toString().toLowerCase());
        if (this.machine != null) {
            meta = String.valueOf(meta) + String.format(", 'machine': '%s'", this.machine.getName());
        }
        if (this.type == PPlaceType.STATE) {
            meta = String.valueOf(meta) + String.format(", 'state': '%s'", this.state.getName());
        }
        return String.format("add_place(Place('%s'%s), {%s})\n", this.name, token, meta);
    }

    static enum PPlaceType {
        PARAMETERS,
        STATE,
        TRANSITION,
        CLAUSE,
        VARIABLES;

    }
}

