/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.simulator;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.BehaviorStandaloneSetup;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.component.ComponentStandaloneSetup;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentModel;
import org.eclipse.comma.behavior.interfaces.InterfaceDefinitionStandaloneSetup;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.InterfaceDefinition;
import org.eclipse.comma.behavior.interfaces.scoping.InterfaceUtilities;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.EComponentState;
import org.eclipse.comma.evaluator.EConnection;
import org.eclipse.comma.evaluator.EIState;
import org.eclipse.comma.evaluator.EInterfaceState;
import org.eclipse.comma.evaluator.ENotification;
import org.eclipse.comma.evaluator.EReply;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.parameters.ParametersCollection;
import org.eclipse.comma.parameters.ParametersStandaloneSetup;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.StringInputStream;

public class Model {
    @Inject
    Provider<ResourceSet> resourceSetProvider;
    @Inject
    IScopeProvider scopeProvider;
    EIState initialState;
    ParametersCollection parameterCollection;
    Map<EAction, String> actions = new HashMap<EAction, String>();
    boolean isComponent;
    String name;

    private void loadInternal() throws IOException {
        InputStream stream = this.getClass().getResourceAsStream("/resource/model.json");
        if (stream == null) {
            stream = new FileInputStream("resource/model.json");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String content = String.join((CharSequence)"\n", reader.lines().collect(Collectors.toList()));
        JsonObject json = (JsonObject)new GsonBuilder().create().fromJson(content, JsonObject.class);
        ResourceSet rs = (ResourceSet)this.resourceSetProvider.get();
        for (Map.Entry resource : json.getAsJsonObject("resources").entrySet()) {
            URI uri = URI.createURI((String)("file://" + (String)resource.getKey()));
            StringInputStream text = new StringInputStream(((JsonElement)resource.getValue()).getAsString());
            rs.createResource(uri).load((InputStream)text, null);
        }
        EObject model = (EObject)rs.getResource(URI.createURI((String)("file://" + json.get("model").getAsString())), false).getContents().get(0);
        if (model instanceof InterfaceDefinition) {
            Interface itf = ((InterfaceDefinition)model).getInterface();
            this.initialState = new EInterfaceState(itf);
            this.name = itf.getName();
            Signature signature = InterfaceUtilities.getSignature((Interface)itf, (IScopeProvider)this.scopeProvider);
            this.addActions(signature);
            this.isComponent = false;
        } else if (model instanceof ComponentModel) {
            Component component = ((ComponentModel)model).getComponent();
            ArrayList<EConnection> connections = new ArrayList<EConnection>();
            for (Port port : component.getPorts()) {
                if (!(port instanceof ProvidedPort)) continue;
                connections.add(new EConnection(port.getName(), "id1"));
                this.addActions(port.getInterface());
            }
            this.initialState = new EComponentState(component, this.scopeProvider, connections);
            this.name = component.getName();
            this.isComponent = true;
        }
        ArrayList<Parameters> parameters = new ArrayList<Parameters>();
        for (JsonElement parameter : json.get("parameters").getAsJsonArray()) {
            parameters.add((Parameters)rs.getResource(URI.createURI((String)("file://" + parameter.getAsString())), false).getContents().get(0));
        }
        this.parameterCollection = new ParametersCollection(parameters);
    }

    private void addActions(Signature signature) {
        signature.getCommands().forEach(c -> {
            this.actions.put((EAction)new ECommand(c.getName(), c.getType().getType()), signature.getName());
            this.actions.put((EAction)new EReply(c.getName(), null, 0), signature.getName());
        });
        signature.getNotifications().forEach(n -> this.actions.put((EAction)new ENotification(n.getName(), 0, null), signature.getName()));
        signature.getSignals().forEach(s -> this.actions.put((EAction)new ESignal(s.getName()), signature.getName()));
    }

    public static Model load() {
        try {
            BehaviorStandaloneSetup.doSetup();
            ParametersStandaloneSetup.doSetup();
            ComponentStandaloneSetup.doSetup();
            Injector injector = new InterfaceDefinitionStandaloneSetup().createInjectorAndDoEMFRegistration();
            Model model = (Model)injector.getInstance(Model.class);
            model.loadInternal();
            return model;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

