/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class JUnitUIPreferencesConstants {
    public static final String SHOW_IN_ALL_VIEWS = "org.eclipse.jdt.junit.show_in_all_views";
    public static final boolean SHOW_IN_ALL_VIEWS_DEFAULT = false;
    private static final String CODEASSIST_FAVORITE_STATIC_MEMBERS_MIGRATED = "org.eclipse.jdt.junit.content_assist_favorite_static_members_migrated";

    private JUnitUIPreferencesConstants() {
    }

    public static boolean getShowInAllViews() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.jdt.junit", SHOW_IN_ALL_VIEWS, false, null);
    }

    public static void setShowInAllViews(boolean show) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.junit");
        preferences.putBoolean(SHOW_IN_ALL_VIEWS, show);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            JUnitPlugin.log(e);
        }
    }

    public static boolean isCodeassistFavoriteStaticMembersMigrated() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.jdt.junit", CODEASSIST_FAVORITE_STATIC_MEMBERS_MIGRATED, false, null);
    }

    public static void setCodeassistFavoriteStaticMembersMigrated(boolean migrated) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.junit");
        preferences.putBoolean(CODEASSIST_FAVORITE_STATIC_MEMBERS_MIGRATED, migrated);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            JUnitPlugin.log(e);
        }
    }
}

