/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.utils;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.AbstractEMFWorkflowComponent;

public class Writer
extends AbstractEMFWorkflowComponent {
    private static final String COMPONENT_NAME = "Writer";
    private boolean OPTION_SCHEMA_LOCATION = true;
    private boolean OPTION_SCHEMA_LOCATION_IMPLEMENTATION = true;
    private String encoding = null;
    private boolean multipleResourcesInCaseOfList = false;
    private boolean cloneSlotContents = false;
    private boolean ignoreEmptySlot = false;

    public void setOPTION_SCHEMA_LOCATION(boolean option_schema_location) {
        this.OPTION_SCHEMA_LOCATION = option_schema_location;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setIgnoreEmptySlot(boolean ignoreEmptySlot) {
        this.ignoreEmptySlot = ignoreEmptySlot;
    }

    public void setMultipleResourcesInCaseOfList(boolean b) {
        this.multipleResourcesInCaseOfList = b;
    }

    public void setCloneSlotContents(boolean b) {
        this.cloneSlotContents = b;
    }

    public void setOPTION_SCHEMA_LOCATION_IMPLEMENTATION(boolean option_schema_location_implementation) {
        this.OPTION_SCHEMA_LOCATION_IMPLEMENTATION = option_schema_location_implementation;
    }

    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.encoding != null && !Charset.isSupported(this.encoding)) {
            issues.addError((WorkflowComponent)this, "invalid encoding value '" + this.encoding + "'.");
        }
    }

    public void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        Resource r;
        Object slotContent = ctx.get(this.getModelSlot());
        if (slotContent == null) {
            if (this.ignoreEmptySlot) {
                issues.addWarning((WorkflowComponent)this, "slot '" + this.getModelSlot() + "' is empty. Not writing anything.");
            } else {
                issues.addError((WorkflowComponent)this, "slot '" + this.getModelSlot() + "' is empty.");
            }
            return;
        }
        if (!(slotContent instanceof Collection) && !(slotContent instanceof EObject)) {
            issues.addError((WorkflowComponent)this, "slot '" + this.getModelSlot() + "' neither contains an EList nor an EObject", slotContent, null, null);
            return;
        }
        if (slotContent instanceof EObject) {
            EObject sc = (EObject)slotContent;
            if (this.cloneSlotContents) {
                if (sc.eResource() == null) {
                    issues.addWarning((WorkflowComponent)this, "model in slot '" + this.getModelSlot() + "' is not yet associated with a resource; cloning it is most likely an error!");
                } else {
                    EcoreUtil.Copier copier = new EcoreUtil.Copier();
                    EObject copy = copier.copy(sc);
                    copier.copyReferences();
                    slotContent = copy;
                }
            } else if (sc.eResource() != null) {
                issues.addWarning((WorkflowComponent)this, "the element in slot '" + this.getModelSlot() + "' is already contained in a resource and will be taken out of that resource!");
            }
        }
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        if (!this.multipleResourcesInCaseOfList) {
            r = this.getResourceSet().createResource(URI.createURI((String)this.getUri()));
            if (slotContent instanceof Collection) {
                r.getContents().addAll((Collection)slotContent);
            } else {
                r.getContents().add((Object)((EObject)slotContent));
            }
            this.write(r);
        } else if (slotContent instanceof Collection) {
            Collection coll = (Collection)slotContent;
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (Object object : coll) {
                EObject eo = (EObject)object;
                Resource r2 = this.getResourceSet().createResource(URI.createURI((String)this.createResourceName(eo)));
                r2.getContents().add((Object)eo);
                resources.add(r2);
            }
            for (Resource r3 : resources) {
                this.write(r3);
            }
        } else {
            r = this.getResourceSet().createResource(URI.createURI((String)this.getUri()));
            r.getContents().add((Object)((EObject)slotContent));
            this.write(r);
        }
    }

    private String createResourceName(EObject eo) {
        return String.valueOf(this.getUri()) + (this.getUri().endsWith("/") ? "" : "/") + this.getName(eo) + ".ecore";
    }

    private String getName(EObject model) {
        return (String)model.eGet(model.eClass().getEStructuralFeature("name"));
    }

    private void write(Resource r) {
        try {
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (this.OPTION_SCHEMA_LOCATION) {
                options.put("SCHEMA_LOCATION", Boolean.TRUE);
            }
            if (this.OPTION_SCHEMA_LOCATION_IMPLEMENTATION) {
                options.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
            }
            if (this.encoding != null) {
                options.put("ENCODING", this.encoding);
            }
            r.save(options);
        }
        catch (IOException e) {
            throw new WorkflowInterruptedException("Problems writing xmi file to " + this.getUri() + " : " + e.getMessage());
        }
    }

    public String getLogMessage() {
        return "Writing model to " + this.uri;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

