/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractRootTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.RootNoExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.RootTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class RootExpressionTypeComputationState
extends ExpressionTypeComputationState {
    private final LightweightTypeReference expectedType;
    private LightweightTypeReference expectedReturnType;

    protected RootExpressionTypeComputationState(StackedResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, AbstractTypeComputationState parent, XExpression expression, LightweightTypeReference expectedType) {
        super(resolvedTypes, featureScopeSession, parent, expression);
        this.expectedType = expectedType;
        this.expectedReturnType = expectedType;
    }

    @Override
    public List<AbstractTypeExpectation> getExpectations(AbstractTypeComputationState actualState) {
        AbstractTypeExpectation result = this.createTypeExpectation(this.expectedType, actualState, true, false);
        return Collections.singletonList(result);
    }

    @Override
    protected List<AbstractTypeExpectation> getReturnExpectations(AbstractTypeComputationState actualState, boolean asActualExpectation) {
        AbstractTypeExpectation result = this.createTypeExpectation(this.expectedReturnType, actualState, !asActualExpectation, true);
        return Collections.singletonList(result);
    }

    protected AbstractTypeExpectation createTypeExpectation(LightweightTypeReference expectedType, AbstractTypeComputationState actualState, boolean voidAllowed, boolean returnType) {
        AbstractRootTypeExpectation result = null;
        if (expectedType != null) {
            LightweightTypeReference copied = expectedType.copyInto(actualState.getReferenceOwner());
            result = new RootTypeExpectation(copied, actualState);
        } else {
            result = returnType ? new PendingRootExpectation(actualState, this, voidAllowed) : new RootNoExpectation(actualState, voidAllowed);
        }
        return result;
    }

    protected static class PendingRootExpectation
    extends RootNoExpectation {
        private RootExpressionTypeComputationState rootState;

        public PendingRootExpectation(AbstractTypeComputationState state, RootExpressionTypeComputationState rootState, boolean voidAllowed) {
            super(state, voidAllowed);
            this.rootState = rootState;
        }

        @Override
        public void acceptActualType(LightweightTypeReference type, int flags) {
            if ((flags & 0x8000000) != 0) {
                this.rootState.expectedReturnType = type;
            }
            super.acceptActualType(type, flags);
        }

        @Override
        public LightweightTypeReference getExpectedType() {
            if (this.rootState.expectedReturnType != null) {
                return this.rootState.expectedReturnType;
            }
            return super.getExpectedType();
        }

        @Override
        public boolean isNoTypeExpectation() {
            if (this.rootState.expectedReturnType != null) {
                return false;
            }
            return super.isNoTypeExpectation();
        }

        @Override
        public boolean isVoidTypeAllowed() {
            if (this.rootState.expectedReturnType != null) {
                return true;
            }
            return super.isVoidTypeAllowed();
        }
    }
}

