/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text.console;

import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.text.AbstractDiagramTextProvider;
import net.sourceforge.plantuml.text.TextDiagramHelper;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class ConsoleViewDiagramTextProvider
extends AbstractDiagramTextProvider
implements ISelectionProvider {
    private final TextDiagramHelper textDiagramHelper = new TextDiagramHelper(this.getStartPlantUml(), this.getStartPlantUml(), this.getEndPlantUml(), this.getEndPlantUml());
    private final IPatternMatchListener patternMatchListener = new IPatternMatchListener(){
        private final String qualifier;
        private final String pattern;
        {
            this.qualifier = ConsoleViewDiagramTextProvider.this.getStartPlantUml();
            this.pattern = String.valueOf(this.qualifier) + "((.|\\n)*)" + ConsoleViewDiagramTextProvider.this.getEndPlantUml();
        }

        public void connect(TextConsole console) {
        }

        public void matchFound(PatternMatchEvent matchEvent) {
            try {
                IDocument contents = ((TextConsole)matchEvent.getSource()).getDocument();
                String match = contents.get(matchEvent.getOffset(), matchEvent.getLength());
                ConsoleViewDiagramTextProvider.this.setSelection(ConsoleViewDiagramTextProvider.this.textDiagramHelper.getDiagramText(match));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void disconnect() {
            ConsoleViewDiagramTextProvider.this.setSelection((ISelection)StructuredSelection.EMPTY);
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getLineQualifier() {
            return this.qualifier;
        }

        public int getCompilerFlags() {
            return 8;
        }
    };
    private ISelection selection = StructuredSelection.EMPTY;
    private final Collection<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();

    public ConsoleViewDiagramTextProvider() {
        this.setEditorType(IConsoleView.class);
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(new IConsoleListener(){

            public void consolesRemoved(IConsole[] consoles) {
                int i = 0;
                while (i < consoles.length) {
                    if (consoles[i] instanceof TextConsole) {
                        ((TextConsole)consoles[i]).removePatternMatchListener(ConsoleViewDiagramTextProvider.this.patternMatchListener);
                    }
                    ++i;
                }
            }

            public void consolesAdded(IConsole[] consoles) {
                int i = 0;
                while (i < consoles.length) {
                    if (consoles[i] instanceof TextConsole) {
                        ((TextConsole)consoles[i]).addPatternMatchListener(ConsoleViewDiagramTextProvider.this.patternMatchListener);
                    }
                    ++i;
                }
            }
        });
    }

    public boolean supportsSelection(ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    protected void setSelection(String diagramText) {
        this.setSelection((ISelection)new StructuredSelection((Object)diagramText));
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.selectionListeners != null && !this.selectionListeners.isEmpty()) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            for (ISelectionChangedListener listener : this.selectionListeners) {
                listener.selectionChanged(event);
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }
}

