/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.spans.ContainSpans;
import org.apache.lucene.search.spans.SpanContainQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;

public final class SpanContainingQuery
extends SpanContainQuery {
    public SpanContainingQuery(SpanQuery big, SpanQuery little) {
        super(big, little);
    }

    @Override
    public String toString(String field) {
        return this.toString(field, "SpanContaining");
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        SpanWeight bigWeight = this.big.createWeight(searcher, scoreMode, boost);
        SpanWeight littleWeight = this.little.createWeight(searcher, scoreMode, boost);
        return new SpanContainingWeight(searcher, scoreMode.needsScores() ? SpanContainingQuery.getTermStates(bigWeight, littleWeight) : null, bigWeight, littleWeight, boost);
    }

    public class SpanContainingWeight
    extends SpanContainQuery.SpanContainWeight {
        public SpanContainingWeight(IndexSearcher searcher, Map<Term, TermStates> terms, SpanWeight bigWeight, SpanWeight littleWeight, float boost) throws IOException {
            super(searcher, terms, bigWeight, littleWeight, boost);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            ArrayList<Spans> containerContained = this.prepareConjunction(context, requiredPostings);
            if (containerContained == null) {
                return null;
            }
            Spans big = containerContained.get(0);
            Spans little = containerContained.get(1);
            return new ContainSpans(big, little, big){

                @Override
                boolean twoPhaseCurrentDocMatches() throws IOException {
                    this.oneExhaustedInCurrentDoc = false;
                    assert (this.littleSpans.startPosition() == -1);
                    while (this.bigSpans.nextStartPosition() != Integer.MAX_VALUE) {
                        while (this.littleSpans.startPosition() < this.bigSpans.startPosition()) {
                            if (this.littleSpans.nextStartPosition() != Integer.MAX_VALUE) continue;
                            this.oneExhaustedInCurrentDoc = true;
                            return false;
                        }
                        if (this.bigSpans.endPosition() < this.littleSpans.endPosition()) continue;
                        this.atFirstInCurrentDoc = true;
                        return true;
                    }
                    this.oneExhaustedInCurrentDoc = true;
                    return false;
                }

                @Override
                public int nextStartPosition() throws IOException {
                    if (this.atFirstInCurrentDoc) {
                        this.atFirstInCurrentDoc = false;
                        return this.bigSpans.startPosition();
                    }
                    while (this.bigSpans.nextStartPosition() != Integer.MAX_VALUE) {
                        while (this.littleSpans.startPosition() < this.bigSpans.startPosition()) {
                            if (this.littleSpans.nextStartPosition() != Integer.MAX_VALUE) continue;
                            this.oneExhaustedInCurrentDoc = true;
                            return Integer.MAX_VALUE;
                        }
                        if (this.bigSpans.endPosition() < this.littleSpans.endPosition()) continue;
                        return this.bigSpans.startPosition();
                    }
                    this.oneExhaustedInCurrentDoc = true;
                    return Integer.MAX_VALUE;
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.bigWeight.isCacheable(ctx) && this.littleWeight.isCacheable(ctx);
        }
    }
}

