/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import org.eclipse.comma.monitoring.lib.CFactory;
import org.eclipse.comma.monitoring.lib.CMonitoringContext;

public class CInterfaceMonitoringContext
extends CMonitoringContext {
    protected String localDir;
    protected String connectionName;
    protected String interfaceName;
    protected boolean isSingleton = false;

    public CInterfaceMonitoringContext(String interfaceName, boolean isSingleton, CFactory factory, String traceResultsDir) {
        super(factory, traceResultsDir);
        this.interfaceName = interfaceName;
        this.isSingleton = isSingleton;
    }

    public CInterfaceMonitoringContext clone() {
        CInterfaceMonitoringContext context = new CInterfaceMonitoringContext(this.interfaceName, this.isSingleton, this.factory, this.resultsDir);
        context.skipTimeConstraints(this.timeConstraintsSkipped);
        context.skipDataConstraints(this.dataConstraintsSkipped);
        return context;
    }

    public CInterfaceMonitoringContext setConnectionName(String connectionName) {
        this.connectionName = connectionName;
        return this;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public CInterfaceMonitoringContext setLocalDir(String localDir) {
        this.localDir = localDir;
        return this;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public String resultsDir() {
        return String.valueOf(this.resultsDir) + this.localDir;
    }

    public String getTraceFile() {
        return String.valueOf(this.resultsDir()) + this.connectionName + "_trace.txt";
    }

    public String getResultsFile() {
        return String.valueOf(this.resultsDir()) + this.connectionName + "_results.txt";
    }

    public String getErrorUMLFile() {
        return String.valueOf(this.resultsDir()) + this.connectionName + "_error_sequence_diagram.plantuml";
    }

    public String getRuleErrorUMLFile(int i) {
        return String.valueOf(this.resultsDir()) + this.connectionName + "_warning_" + i + "_sequence_diagram.plantuml";
    }

    public String getTimeStatisticsFileName() {
        return String.valueOf(this.resultsDir) + "..\\" + "\\statistics\\statisticsTime" + this.connectionName + ".statistics";
    }

    public String getDataStatisticsFileName() {
        return String.valueOf(this.resultsDir) + "..\\" + "\\statistics\\statisticsData" + this.connectionName + ".statistics";
    }
}

