/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.impl.bag.mutable.primitive.UnmodifiableFloatBag;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedFloatCollection;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedFloatBag
extends AbstractSynchronizedFloatCollection
implements MutableFloatBag {
    private static final long serialVersionUID = 1L;

    SynchronizedFloatBag(MutableFloatBag bag) {
        super((MutableFloatCollection)bag);
    }

    SynchronizedFloatBag(MutableFloatBag bag, Object newLock) {
        super((MutableFloatCollection)bag, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableFloatBag getMutableFloatBag() {
        return (MutableFloatBag)this.getFloatCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatBag with(float element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatBag without(float element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatBag withAll(FloatIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatBag withoutAll(FloatIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccurrences(float item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOccurrences(float item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int occurrencesOf(float item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithOccurrences(FloatIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatBag select(FloatPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatBag reject(FloatPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyFloatIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }
    }

    public MutableFloatBag asUnmodifiable() {
        return new UnmodifiableFloatBag(this);
    }

    public MutableFloatBag asSynchronized() {
        return this;
    }

    public ImmutableFloatBag toImmutable() {
        return FloatBags.immutable.withAll((FloatIterable)this);
    }
}

