/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.sorted.immutable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.sorted.ImmutableSortedBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.bag.sorted.SortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.bag.sorted.PartitionImmutableSortedBag;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.impl.Counter;
import org.eclipse.collections.impl.bag.sorted.immutable.AbstractImmutableSortedBag;
import org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import org.eclipse.collections.impl.factory.SortedBags;
import org.eclipse.collections.impl.factory.SortedSets;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.collections.impl.partition.bag.sorted.PartitionImmutableSortedBagImpl;
import org.eclipse.collections.impl.partition.bag.sorted.PartitionTreeBag;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.ListIterate;
import org.eclipse.collections.impl.utility.internal.SortedBagIterables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class ImmutableSortedBagImpl<T>
extends AbstractImmutableSortedBag<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final T[] elements;
    private final int[] occurrences;
    private final Comparator<? super T> comparator;
    private final int size;

    ImmutableSortedBagImpl(SortedBag<T> sortedBag) {
        if (sortedBag.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.comparator = sortedBag.comparator();
        this.elements = new Object[sortedBag.sizeDistinct()];
        this.occurrences = new int[sortedBag.sizeDistinct()];
        this.size = sortedBag.size();
        sortedBag.forEachWithOccurrences(new ObjectIntProcedure<T>(){
            private int i;

            public void value(T each, int occurrencesOfEach) {
                ((ImmutableSortedBagImpl)ImmutableSortedBagImpl.this).elements[this.i] = each;
                ((ImmutableSortedBagImpl)ImmutableSortedBagImpl.this).occurrences[this.i] = occurrencesOfEach;
                ++this.i;
            }
        });
    }

    private ImmutableSortedBagImpl(T[] elements, int[] occurrences, Comparator<? super T> comparator) {
        if (elements.length != occurrences.length) {
            throw new IllegalArgumentException();
        }
        this.comparator = comparator;
        this.elements = elements;
        this.occurrences = occurrences;
        int size = 0;
        for (int occurrence : occurrences) {
            size += occurrence;
        }
        this.size = size;
    }

    public ImmutableSortedBag<T> newWith(T element) {
        int index = Arrays.binarySearch(this.elements, element, this.comparator);
        if (index >= 0) {
            int[] occurrences = (int[])this.occurrences.clone();
            int n = index;
            occurrences[n] = occurrences[n] + 1;
            return new ImmutableSortedBagImpl<T>((Object[])this.elements.clone(), occurrences, this.comparator);
        }
        int insertionPoint = (index + 1) * -1;
        Object[] elements = new Object[this.elements.length + 1];
        int[] occurrences = new int[this.occurrences.length + 1];
        System.arraycopy(this.elements, 0, elements, 0, insertionPoint);
        System.arraycopy(this.occurrences, 0, occurrences, 0, insertionPoint);
        elements[insertionPoint] = element;
        occurrences[insertionPoint] = 1;
        System.arraycopy(this.elements, insertionPoint, elements, insertionPoint + 1, this.elements.length - insertionPoint);
        System.arraycopy(this.occurrences, insertionPoint, occurrences, insertionPoint + 1, this.occurrences.length - insertionPoint);
        return new ImmutableSortedBagImpl<T>(elements, occurrences, this.comparator);
    }

    public ImmutableSortedBag<T> newWithout(T element) {
        int index = Arrays.binarySearch(this.elements, element, this.comparator);
        if (index < 0) {
            return this;
        }
        if (this.occurrences[index] > 1) {
            int[] occurrences = (int[])this.occurrences.clone();
            int n = index;
            occurrences[n] = occurrences[n] - 1;
            return new ImmutableSortedBagImpl<T>((Object[])this.elements.clone(), occurrences, this.comparator);
        }
        Object[] elements = new Object[this.elements.length - 1];
        int[] occurrences = new int[this.occurrences.length - 1];
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(this.occurrences, 0, occurrences, 0, index);
        System.arraycopy(this.elements, index + 1, elements, index, elements.length - index);
        System.arraycopy(this.occurrences, index + 1, occurrences, index, occurrences.length - index);
        return new ImmutableSortedBagImpl<T>(elements, occurrences, this.comparator);
    }

    public ImmutableSortedBag<T> newWithAll(Iterable<? extends T> elements) {
        TreeBag result = TreeBag.newBag(this);
        result.addAllIterable(elements);
        return result.toImmutable();
    }

    public Comparator<? super T> comparator() {
        return this.comparator;
    }

    @Override
    public T min() {
        return ArrayIterate.min(this.elements);
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        return ArrayIterate.min(this.elements, comparator);
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        return ArrayIterate.minBy(this.elements, function);
    }

    @Override
    public T max() {
        return ArrayIterate.max(this.elements);
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        return ArrayIterate.max(this.elements, comparator);
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        return ArrayIterate.maxBy(this.elements, function);
    }

    public ImmutableSortedBag<T> takeWhile(Predicate<? super T> predicate) {
        TreeBag<? super T> bag = TreeBag.newBag(this.comparator);
        for (int i = 0; i < this.elements.length; ++i) {
            if (!predicate.accept(this.elements[i])) {
                return bag.toImmutable();
            }
            bag.addOccurrences(this.elements[i], this.occurrences[i]);
        }
        return bag.toImmutable();
    }

    public ImmutableSortedBag<T> dropWhile(Predicate<? super T> predicate) {
        int startIndex;
        TreeBag<? super T> bag = TreeBag.newBag(this.comparator);
        for (int i = startIndex = this.detectNotIndex(predicate); i < this.elements.length; ++i) {
            bag.addOccurrences(this.elements[i], this.occurrences[i]);
        }
        return bag.toImmutable();
    }

    public int detectIndex(Predicate<? super T> predicate) {
        int result = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            if (predicate.accept(this.elements[i])) {
                return result;
            }
            result += this.occurrences[i];
        }
        return -1;
    }

    private int detectNotIndex(Predicate<? super T> predicate) {
        for (int index = 0; index < this.elements.length; ++index) {
            if (predicate.accept(this.elements[index])) continue;
            return index;
        }
        return this.elements.length;
    }

    public PartitionImmutableSortedBag<T> partitionWhile(Predicate<? super T> predicate) {
        PartitionTreeBag<T> result = new PartitionTreeBag<T>(this.comparator());
        MutableSortedBag<T> selected = result.getSelected();
        MutableSortedBag<T> rejected = result.getRejected();
        int partitionIndex = this.detectNotIndex(predicate);
        for (int i = 0; i < partitionIndex; ++i) {
            selected.addOccurrences(this.elements[i], this.occurrences[i]);
        }
        for (int j = partitionIndex; j < this.elements.length; ++j) {
            rejected.addOccurrences(this.elements[j], this.occurrences[j]);
        }
        return new PartitionImmutableSortedBagImpl<T>(result);
    }

    public void forEachWithOccurrences(ObjectIntProcedure<? super T> procedure) {
        for (int i = 0; i < this.occurrences.length; ++i) {
            procedure.value(this.elements[i], this.occurrences[i]);
        }
    }

    public int sizeDistinct() {
        return this.elements.length;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int indexOf(Object object) {
        int result = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            if (object.equals(this.elements[i])) {
                return result;
            }
            result += this.occurrences[i];
        }
        return -1;
    }

    public T getFirst() {
        return ArrayIterate.getFirst(this.elements);
    }

    public T getLast() {
        return ArrayIterate.getLast(this.elements);
    }

    public void forEach(int fromIndex, int toIndex, Procedure<? super T> procedure) {
        int j;
        int index = fromIndex;
        ListIterate.rangeCheck(index, toIndex, this.size());
        if (index > toIndex) {
            throw new IllegalArgumentException("fromIndex must not be greater than toIndex");
        }
        int i = 0;
        int beginningIndex = 0;
        while (beginningIndex <= index) {
            if ((beginningIndex += this.occurrences[i]) > index) continue;
            ++i;
        }
        int numberOfIterations = beginningIndex - index;
        for (j = 0; j < numberOfIterations && index <= toIndex; ++index, ++j) {
            procedure.value(this.elements[i]);
        }
        while (index <= toIndex) {
            ++i;
            for (j = 0; j < this.occurrences[i] && index <= toIndex; ++index, ++j) {
                procedure.value(this.elements[i]);
            }
        }
    }

    public void each(Procedure<? super T> procedure) {
        for (int i = 0; i < this.elements.length; ++i) {
            T element = this.elements[i];
            int occurrences = this.occurrences[i];
            for (int j = 0; j < occurrences; ++j) {
                procedure.value(element);
            }
        }
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        int index = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.occurrences[i]; ++j) {
                objectIntProcedure.value(this.elements[i], index);
                ++index;
            }
        }
    }

    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
        int j;
        ListIterate.rangeCheck(fromIndex, toIndex, this.size());
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex must not be greater than toIndex");
        }
        int arrayIndex = 0;
        int index = fromIndex;
        int i = 0;
        while (i <= index) {
            if ((i += this.occurrences[arrayIndex]) > index) continue;
            ++arrayIndex;
        }
        int numberOfIterations = i - index;
        for (j = 0; j < numberOfIterations && index <= toIndex; ++index, ++j) {
            objectIntProcedure.value(this.elements[arrayIndex], index);
        }
        while (index <= toIndex) {
            ++arrayIndex;
            for (j = 0; j < this.occurrences[arrayIndex] && index <= toIndex; ++index, ++j) {
                objectIntProcedure.value(this.elements[arrayIndex], index);
            }
        }
    }

    public int occurrencesOf(Object item) {
        int index = Arrays.binarySearch(this.elements, item, this.comparator);
        if (index > -1) {
            return this.occurrences[index];
        }
        return 0;
    }

    public ImmutableSortedSet<T> distinct() {
        return SortedSets.immutable.with(this.comparator(), (Object[])this.elements);
    }

    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
        if (this.size != other.size()) {
            return false;
        }
        if (other instanceof RandomAccess) {
            List otherList = (List)other;
            int otherListIndex = 0;
            for (int i = 0; i < this.elements.length; ++i) {
                for (int j = 0; j < this.occurrences[i]; ++j) {
                    if (!predicate.accept(this.elements[i], otherList.get(otherListIndex))) {
                        return false;
                    }
                    ++otherListIndex;
                }
            }
            return true;
        }
        Iterator otherIterator = other.iterator();
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.occurrences[i]; ++j) {
                if (predicate.accept(this.elements[i], otherIterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public MutableList<T> toSortedList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public MutableSortedSet<T> toSortedSet() {
        return SortedSets.mutable.with((Object[])this.elements);
    }

    @Override
    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        return SortedSets.mutable.with(comparator, (Object[])this.elements);
    }

    @Override
    public Object[] toArray() {
        final Object[] result = new Object[this.size()];
        this.each(new Procedure<T>(){
            private int i;

            public void value(T each) {
                result[this.i] = each;
                ++this.i;
            }
        });
        return result;
    }

    @Override
    public <E> E[] toArray(E[] array) {
        Object[] array1 = array;
        if (array1.length < this.size) {
            array1 = (Object[])Array.newInstance(array1.getClass().getComponentType(), this.size);
        }
        Object[] items = this.toArray();
        System.arraycopy(items, 0, array1, 0, this.size);
        if (array1.length > this.size) {
            array1[this.size] = null;
        }
        return array1;
    }

    public MutableSortedMap<T, Integer> toMapOfItemToCount() {
        final TreeSortedMap map = TreeSortedMap.newMap(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T item, int count) {
                map.put(item, (Object)count);
            }
        });
        return map;
    }

    public int compareTo(SortedBag<T> otherBag) {
        return SortedBagIterables.compare(this, otherBag);
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return ArrayIterate.allSatisfy(this.elements, predicate);
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return ArrayIterate.allSatisfyWith(this.elements, predicate, parameter);
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return ArrayIterate.anySatisfy(this.elements, predicate);
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return ArrayIterate.anySatisfyWith(this.elements, predicate, parameter);
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return ArrayIterate.noneSatisfy(this.elements, predicate);
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return ArrayIterate.noneSatisfyWith(this.elements, predicate, parameter);
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return ArrayIterate.detect(this.elements, predicate);
    }

    @Override
    public boolean contains(Object object) {
        return Arrays.binarySearch(this.elements, object, this.comparator) >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new InternalIterator();
    }

    public ImmutableSortedBag<T> take(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        if (count == 0) {
            return SortedBags.immutable.empty(this.comparator());
        }
        if (count >= this.size()) {
            return this;
        }
        TreeBag<T> output = TreeBag.newBag(this.comparator());
        int index = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.occurrences[i]; ++j) {
                output.add(this.elements[i]);
                if (++index < count) continue;
                return output.toImmutable();
            }
        }
        throw new AssertionError();
    }

    public ImmutableSortedBag<T> drop(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        if (count == 0) {
            return this;
        }
        if (count >= this.size()) {
            return SortedBags.immutable.empty(this.comparator());
        }
        TreeBag<T> output = TreeBag.newBag(this.comparator());
        int index = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.occurrences[i]; ++j) {
                if (index >= count) {
                    output.add(this.elements[i]);
                }
                ++index;
            }
        }
        return output.toImmutable();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bag)) {
            return false;
        }
        Bag bag = (Bag)other;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (bag.occurrencesOf(this.elements[i]) == this.occurrences[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        final Counter counter = new Counter();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int count) {
                counter.add((each == null ? 0 : each.hashCode()) ^ count);
            }
        });
        return counter.getCount();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalIterator
    implements Iterator<T> {
        private int position;
        private int occurrencesRemaining;

        private InternalIterator() {
            this.occurrencesRemaining = ImmutableSortedBagImpl.this.isEmpty() ? 0 : ImmutableSortedBagImpl.this.occurrences[0];
        }

        @Override
        public boolean hasNext() {
            return this.position < ImmutableSortedBagImpl.this.elements.length - 1 || this.occurrencesRemaining != 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.occurrencesRemaining == 0) {
                ++this.position;
                this.occurrencesRemaining = ImmutableSortedBagImpl.this.occurrences[this.position];
            }
            --this.occurrencesRemaining;
            return ImmutableSortedBagImpl.this.elements[this.position];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
        }
    }
}

