/*
 * Copyright (c) 2018 Goldman Sachs and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.stack.primitive;

import org.eclipse.collections.api.block.function.primitive.ShortIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.stack.MutableStack;

/**
 * This file was automatically generated from template file mutablePrimitiveStack.stg.
 *
 * @since 3.0.
 */
public interface MutableShortStack extends ShortStack
{
    /**
     * Adds an item to the top of the stack.
     */
    void push(short item);

    /**
     * Removes and returns the top element of the stack.
     */
    short pop();

    /**
     * Removes and returns a ShortList of the number of elements specified by the count, beginning with the top of the stack.
     */
    ShortList pop(int count);

    /**
     * Clears the Stack
     */
    void clear();

    @Override
    MutableShortStack select(ShortPredicate predicate);

    @Override
    MutableShortStack reject(ShortPredicate predicate);

    /**
     * @since 9.0.
     */
    @Override
    default MutableShortStack tap(ShortProcedure procedure)
    {
        this.forEach(procedure);
        return this;
    }

    @Override
    <V> MutableStack<V> collect(ShortToObjectFunction<? extends V> function);

    /**
     * Returns a new MutableStack using results obtained by applying the specified function to each element
     * and its corresponding index.
     *
     * @since 9.1.
     */
    @Override
    default <V> MutableStack<V> collectWithIndex(ShortIntToObjectFunction<? extends V> function)
    {
        int[] index = { 0 };
        return this.collect(each -> function.value(each, index[0]++));
    }

    MutableShortStack asUnmodifiable();

    MutableShortStack asSynchronized();
}
