/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteFloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.ByteFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.ByteFloatPair;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.factory.primitive.FloatByteMaps;
import org.eclipse.collections.impl.iterator.ImmutableEmptyFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteFloatSingletonMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyByteIterate;

final class ImmutableByteFloatEmptyMap
implements ImmutableByteFloatMap,
Serializable {
    static final ImmutableByteFloatMap INSTANCE = new ImmutableByteFloatEmptyMap();
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;

    ImmutableByteFloatEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public float get(byte key) {
        return 0.0f;
    }

    @Override
    public float getIfAbsent(byte key, float ifAbsent) {
        return ifAbsent;
    }

    @Override
    public float getOrThrow(byte key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(byte key) {
        return false;
    }

    @Override
    public boolean containsValue(float value) {
        return false;
    }

    @Override
    public void forEachValue(FloatProcedure procedure) {
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
    }

    @Override
    public void forEachKeyValue(ByteFloatProcedure procedure) {
    }

    @Override
    public LazyByteIterable keysView() {
        return LazyByteIterate.empty();
    }

    @Override
    public RichIterable<ByteFloatPair> keyValuesView() {
        return LazyIterate.empty();
    }

    @Override
    public ImmutableFloatByteMap flipUniqueValues() {
        return FloatByteMaps.immutable.empty();
    }

    @Override
    public ImmutableByteFloatMap select(ByteFloatPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableByteFloatMap reject(ByteFloatPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableByteFloatMap toImmutable() {
        return this;
    }

    @Override
    public FloatIterator floatIterator() {
        return ImmutableEmptyFloatIterator.INSTANCE;
    }

    @Override
    public void forEach(FloatProcedure procedure) {
    }

    @Override
    public void each(FloatProcedure procedure) {
    }

    @Override
    public int count(FloatPredicate predicate) {
        return 0;
    }

    @Override
    public double sum() {
        return 0.0;
    }

    @Override
    public float min() {
        throw new NoSuchElementException();
    }

    @Override
    public float max() {
        throw new NoSuchElementException();
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return defaultValue;
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public float[] toSortedArray() {
        return new float[0];
    }

    @Override
    public MutableFloatList toSortedList() {
        return new FloatArrayList();
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return true;
    }

    @Override
    public ImmutableFloatBag select(FloatPredicate predicate) {
        return FloatBags.immutable.empty();
    }

    @Override
    public ImmutableFloatBag reject(FloatPredicate predicate) {
        return FloatBags.immutable.empty();
    }

    @Override
    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        return Bags.immutable.empty();
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return ifNone;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public float[] toArray() {
        return new float[0];
    }

    @Override
    public boolean contains(float value) {
        return false;
    }

    @Override
    public boolean containsAll(float ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        return source.isEmpty();
    }

    @Override
    public MutableFloatList toList() {
        return new FloatArrayList();
    }

    @Override
    public MutableFloatSet toSet() {
        return new FloatHashSet();
    }

    @Override
    public MutableFloatBag toBag() {
        return new FloatHashBag();
    }

    @Override
    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public ImmutableByteFloatMap newWithKeyValue(byte key, float value) {
        return new ImmutableByteFloatSingletonMap(key, value);
    }

    @Override
    public ImmutableByteFloatMap newWithoutKey(byte key) {
        return this;
    }

    @Override
    public ImmutableByteFloatMap newWithoutAllKeys(ByteIterable keys) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(new ByteHashSet());
    }

    @Override
    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(new FloatArrayList());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteFloatMap)) {
            return false;
        }
        ByteFloatMap map = (ByteFloatMap)obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public String toString() {
        return "{}";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

