/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableObjectIntMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectIntEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectIntHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectIntSingletonMap;

public enum ImmutableObjectIntMapFactoryImpl implements ImmutableObjectIntMapFactory
{
    INSTANCE;


    @Override
    public <K> ImmutableObjectIntMap<K> empty() {
        return ImmutableObjectIntEmptyMap.INSTANCE;
    }

    @Override
    public <K> ImmutableObjectIntMap<K> of() {
        return this.empty();
    }

    @Override
    public <K> ImmutableObjectIntMap<K> with() {
        return this.empty();
    }

    @Override
    public <K> ImmutableObjectIntMap<K> of(K key, int value) {
        return this.with(key, value);
    }

    @Override
    public <K> ImmutableObjectIntMap<K> with(K key, int value) {
        return new ImmutableObjectIntSingletonMap<K>(key, value);
    }

    @Override
    public <K> ImmutableObjectIntMap<K> ofAll(ObjectIntMap<? extends K> map) {
        return this.withAll(map);
    }

    @Override
    public <K> ImmutableObjectIntMap<K> withAll(ObjectIntMap<? extends K> map) {
        if (map instanceof ImmutableObjectIntMap) {
            return (ImmutableObjectIntMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            Object[] array = new Object[1];
            map.forEachKey(each -> {
                array[0] = each;
            });
            return new ImmutableObjectIntSingletonMap<Object>(array[0], map.get(array[0]));
        }
        return new ImmutableObjectIntHashMap<K>(map);
    }
}

