/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.factory;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.block.function.PassThruFunction0;
import org.eclipse.collections.impl.block.function.checked.CheckedFunction0;
import org.eclipse.collections.impl.block.function.checked.ThrowingFunction0;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.factory.Sets;

public final class Functions0 {
    private static final TrueFunction TRUE_FUNCTION = new TrueFunction();
    private static final FalseFunction FALSE_FUNCTION = new FalseFunction();
    private static final NewFastListFunction<?> NEW_FAST_LIST_FUNCTION = new NewFastListFunction();
    private static final NewUnifiedSetFunction<?> NEW_UNIFIED_SET_FUNCTION = new NewUnifiedSetFunction();
    private static final NewHashBagFunction<?> NEW_HASH_BAG_FUNCTION = new NewHashBagFunction();
    private static final NewUnifiedMapFunction<?, ?> NEW_UNIFIED_MAP_FUNCTION = new NewUnifiedMapFunction();
    private static final NullFunction<?> NULL_FUNCTION = new NullFunction();
    private static final AtomicIntegerZeroFunction ATOMIC_INTEGER_ZERO = new AtomicIntegerZeroFunction();
    private static final AtomicLongZeroFunction ATOMIC_LONG_ZERO = new AtomicLongZeroFunction();
    private static final IntegerZeroFunction INTEGER_ZERO = new IntegerZeroFunction();
    private static final BigDecimalZeroFunction BIG_DECIMAL_ZERO = new BigDecimalZeroFunction();
    private static final BigIntegerZeroFunction BIG_INTEGER_ZERO = new BigIntegerZeroFunction();

    private Functions0() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static Function0<Boolean> getTrue() {
        return TRUE_FUNCTION;
    }

    public static Function0<Boolean> getFalse() {
        return FALSE_FUNCTION;
    }

    public static <T> Function0<MutableList<T>> newFastList() {
        return NEW_FAST_LIST_FUNCTION;
    }

    public static <T> Function0<MutableSet<T>> newUnifiedSet() {
        return NEW_UNIFIED_SET_FUNCTION;
    }

    public static <T> Function0<MutableBag<T>> newHashBag() {
        return NEW_HASH_BAG_FUNCTION;
    }

    public static <K, V> Function0<MutableMap<K, V>> newUnifiedMap() {
        return NEW_UNIFIED_MAP_FUNCTION;
    }

    public static <T> Function0<T> throwing(ThrowingFunction0<T> throwingFunction0) {
        return new ThrowingFunction0Adapter(throwingFunction0);
    }

    public static <T> Function0<T> throwing(ThrowingFunction0<T> throwingFunction0, Function<? super Throwable, ? extends RuntimeException> rethrow) {
        return () -> {
            try {
                return throwingFunction0.safeValue();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw (RuntimeException)rethrow.valueOf(t);
            }
        };
    }

    public static <T> Function0<T> nullValue() {
        return NULL_FUNCTION;
    }

    public static <T> Function0<T> value(T t) {
        return new PassThruFunction0<T>(t);
    }

    public static Function0<Integer> zeroInteger() {
        return INTEGER_ZERO;
    }

    public static Function0<AtomicInteger> zeroAtomicInteger() {
        return ATOMIC_INTEGER_ZERO;
    }

    public static Function0<AtomicLong> zeroAtomicLong() {
        return ATOMIC_LONG_ZERO;
    }

    public static Function0<BigDecimal> zeroBigDecimal() {
        return BIG_DECIMAL_ZERO;
    }

    public static Function0<BigInteger> zeroBigInteger() {
        return BIG_INTEGER_ZERO;
    }

    private static final class FalseFunction
    implements Function0<Boolean> {
        private static final long serialVersionUID = 1L;

        private FalseFunction() {
        }

        @Override
        public Boolean value() {
            return Boolean.FALSE;
        }
    }

    private static final class TrueFunction
    implements Function0<Boolean> {
        private static final long serialVersionUID = 1L;

        private TrueFunction() {
        }

        @Override
        public Boolean value() {
            return Boolean.TRUE;
        }
    }

    private static final class BigIntegerZeroFunction
    implements Function0<BigInteger> {
        private static final long serialVersionUID = 1L;

        private BigIntegerZeroFunction() {
        }

        @Override
        public BigInteger value() {
            return BigInteger.ZERO;
        }
    }

    private static final class BigDecimalZeroFunction
    implements Function0<BigDecimal> {
        private static final long serialVersionUID = 1L;

        private BigDecimalZeroFunction() {
        }

        @Override
        public BigDecimal value() {
            return BigDecimal.ZERO;
        }
    }

    private static final class ThrowingFunction0Adapter<T>
    extends CheckedFunction0<T> {
        private static final long serialVersionUID = 1L;
        private final ThrowingFunction0<T> throwingFunction0;

        private ThrowingFunction0Adapter(ThrowingFunction0<T> throwingFunction0) {
            this.throwingFunction0 = throwingFunction0;
        }

        @Override
        public T safeValue() throws Exception {
            return this.throwingFunction0.safeValue();
        }
    }

    private static final class AtomicLongZeroFunction
    implements Function0<AtomicLong> {
        private static final long serialVersionUID = 1L;

        private AtomicLongZeroFunction() {
        }

        @Override
        public AtomicLong value() {
            return new AtomicLong(0L);
        }
    }

    private static final class AtomicIntegerZeroFunction
    implements Function0<AtomicInteger> {
        private static final long serialVersionUID = 1L;

        private AtomicIntegerZeroFunction() {
        }

        @Override
        public AtomicInteger value() {
            return new AtomicInteger(0);
        }
    }

    private static final class IntegerZeroFunction
    implements Function0<Integer> {
        private static final long serialVersionUID = 1L;

        private IntegerZeroFunction() {
        }

        @Override
        public Integer value() {
            return 0;
        }
    }

    private static final class NullFunction<T>
    implements Function0<T> {
        private static final long serialVersionUID = 1L;

        private NullFunction() {
        }

        @Override
        public T value() {
            return null;
        }
    }

    private static final class NewHashBagFunction<T>
    implements Function0<MutableBag<T>> {
        private static final long serialVersionUID = 1L;

        private NewHashBagFunction() {
        }

        @Override
        public MutableBag<T> value() {
            return Bags.mutable.empty();
        }
    }

    private static final class NewUnifiedSetFunction<T>
    implements Function0<MutableSet<T>> {
        private static final long serialVersionUID = 1L;

        private NewUnifiedSetFunction() {
        }

        @Override
        public MutableSet<T> value() {
            return Sets.mutable.empty();
        }
    }

    private static final class NewUnifiedMapFunction<K, V>
    implements Function0<MutableMap<K, V>> {
        private static final long serialVersionUID = 1L;

        private NewUnifiedMapFunction() {
        }

        @Override
        public MutableMap<K, V> value() {
            return Maps.mutable.empty();
        }
    }

    private static final class NewFastListFunction<T>
    implements Function0<MutableList<T>> {
        private static final long serialVersionUID = 1L;

        private NewFastListFunction() {
        }

        @Override
        public MutableList<T> value() {
            return Lists.mutable.empty();
        }
    }
}

