/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api;

import java.util.Collection;
import java.util.IntSummaryStatistics;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.CharToByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.CharToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.CharToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.CharToIntFunction;
import org.eclipse.collections.api.block.function.primitive.CharToLongFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.CharToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;

public interface CharIterable
extends PrimitiveIterable {
    public CharIterator charIterator();

    public char[] toArray();

    public boolean contains(char var1);

    public boolean containsAll(char ... var1);

    public boolean containsAll(CharIterable var1);

    public void forEach(CharProcedure var1);

    public void each(CharProcedure var1);

    public CharIterable select(CharPredicate var1);

    public CharIterable reject(CharPredicate var1);

    default public <R extends MutableCharCollection> R select(CharPredicate predicate, R target) {
        this.each(each -> {
            if (predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    default public <R extends MutableCharCollection> R reject(CharPredicate predicate, R target) {
        this.each(each -> {
            if (!predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    public <V> RichIterable<V> collect(CharToObjectFunction<? extends V> var1);

    default public <V, R extends Collection<V>> R collect(CharToObjectFunction<? extends V> function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <V, R extends Collection<V>> R flatCollect(CharToObjectFunction<? extends Iterable<V>> function, R target) {
        this.each(each -> {
            Iterable iterable = (Iterable)function.valueOf(each);
            if (iterable instanceof Collection) {
                target.addAll((Collection)iterable);
            } else {
                iterable.forEach(target::add);
            }
        });
        return target;
    }

    default public <R extends MutableBooleanCollection> R collectBoolean(CharToBooleanFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableByteCollection> R collectByte(CharToByteFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableCharCollection> R collectChar(CharToCharFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableShortCollection> R collectShort(CharToShortFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableIntCollection> R collectInt(CharToIntFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableFloatCollection> R collectFloat(CharToFloatFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableLongCollection> R collectLong(CharToLongFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableDoubleCollection> R collectDouble(CharToDoubleFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    public char detectIfNone(CharPredicate var1, char var2);

    public int count(CharPredicate var1);

    public boolean anySatisfy(CharPredicate var1);

    public boolean allSatisfy(CharPredicate var1);

    public boolean noneSatisfy(CharPredicate var1);

    public MutableCharList toList();

    public MutableCharSet toSet();

    public MutableCharBag toBag();

    public LazyCharIterable asLazy();

    public <T> T injectInto(T var1, ObjectCharToObjectFunction<? super T, ? extends T> var2);

    public long sum();

    default public IntSummaryStatistics summaryStatistics() {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    public char max();

    public char maxIfEmpty(char var1);

    public char min();

    public char minIfEmpty(char var1);

    public double average();

    default public double averageIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.average();
    }

    public double median();

    default public double medianIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.median();
    }

    public char[] toSortedArray();

    public MutableCharList toSortedList();
}

