/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableCharObjectMapFactory;
import org.eclipse.collections.api.map.primitive.CharObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharObjectMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharObjectSingletonMap;

public class ImmutableCharObjectMapFactoryImpl
implements ImmutableCharObjectMapFactory {
    @Override
    public <V> ImmutableCharObjectMap<V> empty() {
        return ImmutableCharObjectEmptyMap.INSTANCE;
    }

    @Override
    public <V> ImmutableCharObjectMap<V> of() {
        return this.empty();
    }

    @Override
    public <V> ImmutableCharObjectMap<V> with() {
        return this.empty();
    }

    @Override
    public <V> ImmutableCharObjectMap<V> of(char key, V value) {
        return this.with(key, value);
    }

    @Override
    public <V> ImmutableCharObjectMap<V> with(char key, V value) {
        return new ImmutableCharObjectSingletonMap<V>(key, value);
    }

    @Override
    public <V> ImmutableCharObjectMap<V> ofAll(CharObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    @Override
    public <V> ImmutableCharObjectMap<V> withAll(CharObjectMap<? extends V> map) {
        if (map instanceof ImmutableCharObjectMap) {
            return (ImmutableCharObjectMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            char[] array = new char[1];
            map.forEachKey(each -> {
                array[0] = each;
            });
            return new ImmutableCharObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableCharObjectHashMap<V>(map);
    }
}

