/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.factory.primitive;

import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.primitive.FloatFloatToObjectFunction;
import org.eclipse.collections.api.factory.set.primitive.ImmutableFloatSetFactory;
import org.eclipse.collections.api.factory.set.primitive.MutableFloatSetFactory;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.tuple.primitive.FloatFloatPair;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableFloatSetFactoryImpl;
import org.eclipse.collections.impl.set.mutable.primitive.MutableFloatSetFactoryImpl;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public final class FloatSets {
    public static final ImmutableFloatSetFactory immutable = new ImmutableFloatSetFactoryImpl();
    public static final MutableFloatSetFactory mutable = new MutableFloatSetFactoryImpl();

    private FloatSets() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <A, B> LazyIterable<FloatFloatPair> cartesianProduct(FloatSet set1, FloatSet set2) {
        return FloatSets.cartesianProduct(set1, set2, PrimitiveTuples::pair);
    }

    public static <A, B, C> LazyIterable<C> cartesianProduct(FloatSet set1, FloatSet set2, FloatFloatToObjectFunction<C> function) {
        return set1.asLazy().flatCollect(first -> set2.asLazy().collect(second -> function.value(first, second)));
    }
}

