/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.NotThreadSafe;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableDoubleStack;
import org.eclipse.collections.api.stack.primitive.MutableDoubleStack;
import org.eclipse.collections.impl.factory.primitive.DoubleStacks;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedDoubleStack;
import org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableDoubleStack;
import org.eclipse.collections.impl.stack.primitive.AbstractDoubleStack;

@NotThreadSafe
public final class DoubleArrayStack
extends AbstractDoubleStack
implements MutableDoubleStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient DoubleArrayList delegate;

    public DoubleArrayStack() {
        this.delegate = new DoubleArrayList();
    }

    private DoubleArrayStack(int size) {
        this.delegate = new DoubleArrayList(size);
    }

    private DoubleArrayStack(double ... items) {
        this.delegate = new DoubleArrayList(items);
    }

    public static DoubleArrayStack newStackFromTopToBottom(double ... items) {
        DoubleArrayStack stack = new DoubleArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static DoubleArrayStack newStackWith(double ... items) {
        return new DoubleArrayStack(items);
    }

    public static DoubleArrayStack newStack(DoubleIterable items) {
        DoubleArrayStack stack = new DoubleArrayStack(items.size());
        stack.delegate = DoubleArrayList.newList(items);
        return stack;
    }

    public static DoubleArrayStack newStackFromTopToBottom(DoubleIterable items) {
        DoubleArrayStack stack = new DoubleArrayStack(items.size());
        stack.delegate = DoubleArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    protected DoubleArrayList getDelegate() {
        return this.delegate;
    }

    @Override
    public void push(double item) {
        this.delegate.add(item);
    }

    @Override
    public double pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    @Override
    public DoubleList pop(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new DoubleArrayList(0);
        }
        DoubleArrayList subList = new DoubleArrayList(count);
        while (count > 0) {
            subList.add(this.pop());
            --count;
        }
        return subList;
    }

    @Override
    public MutableDoubleStack select(DoublePredicate predicate) {
        return DoubleArrayStack.newStackFromTopToBottom(this.delegate.asReversed().select(predicate));
    }

    @Override
    public MutableDoubleStack reject(DoublePredicate predicate) {
        return DoubleArrayStack.newStackFromTopToBottom(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public <V> MutableStack<V> collect(DoubleToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect((DoubleToObjectFunction)function));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList(this).sortThis();
    }

    @Override
    public MutableDoubleStack asUnmodifiable() {
        return new UnmodifiableDoubleStack(this);
    }

    @Override
    public MutableDoubleStack asSynchronized() {
        return new SynchronizedDoubleStack(this);
    }

    @Override
    public ImmutableDoubleStack toImmutable() {
        return DoubleStacks.immutable.withAll(this.delegate);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        DoubleIterator iterator = this.delegate.asReversed().doubleIterator();
        while (iterator.hasNext()) {
            double each = iterator.next();
            out.writeDouble(each);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        double[] array = new double[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = in.readDouble();
        }
        this.delegate = DoubleArrayList.newListWith(array);
    }
}

