/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

public class BoxedMutableLongSet
extends AbstractMutableSet<Long>
implements MutableSet<Long> {
    private final MutableLongSet delegate;

    public BoxedMutableLongSet(MutableLongSet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Long getFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void each(Procedure<? super Long> procedure) {
        this.delegate.each(procedure::value);
    }

    @Override
    public boolean add(Long item) {
        return this.delegate.add(item);
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Long && this.delegate.contains((Long)object);
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Long && this.delegate.remove((Long)object);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public ParallelUnsortedSetIterable<Long> asParallel(ExecutorService executorService, int batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    @Override
    public Iterator<Long> iterator() {
        return new BoxedPrimitiveLongSetIterator(this.delegate.longIterator());
    }

    private static final class BoxedPrimitiveLongSetIterator
    implements Iterator<Long> {
        private final MutableLongIterator delegate;

        private BoxedPrimitiveLongSetIterator(MutableLongIterator iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Long next() {
            return this.delegate.next();
        }
    }
}

