/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.map.primitive.ImmutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedObjectIntProcedure;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;

public abstract class AbstractImmutableObjectIntMap<V>
implements ImmutableObjectIntMap<V> {

    protected static class ImmutableObjectIntMapSerializationProxy<V>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ObjectIntMap<V> map;

        public ImmutableObjectIntMapSerializationProxy() {
        }

        protected ImmutableObjectIntMapSerializationProxy(ObjectIntMap<V> map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedObjectIntProcedure<V>(){

                    @Override
                    public void safeValue(V key, int value) throws IOException {
                        out.writeObject(key);
                        out.writeInt(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ObjectIntHashMap<V> deserializedMap = new ObjectIntHashMap<V>();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readObject(), in.readInt());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

